package immibis.ars;


import ic2.core.block.generator.tileentity.TileEntityReactorChamber;

import java.util.List;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUpgrades extends BlockContainer
{

	private int blockid;
	
	public static final int META_REACTOR_MONITOR_CLIENT = 0;
	public static final int META_SUBWATER = 1;
	public static final int META_DOME = 2;
	public static final int META_HARDNER = 3;
	public static final int META_CORE_STORAGE = 4;
	public static final int META_CORE_RANGE = 5;
	public static final int META_ZAPPER = 6;
	public static final int META_CAMO = 7;
	public static final int META_REACTOR_CONNECTOR = 8;
	public static final int META_INHIBITOR = 9;
	
	public static final int MAX_META = 10;

	public BlockUpgrades(int i) {

		super(i, Material.iron);
		blockid = i;
		setHardness(3F);
		setResistance(50F);
		setStepSound(soundMetalFootstep);
		
		setCreativeTab(CreativeTabs.tabMisc);

	}

	public int getBlockid() {
		return blockid;
	}

	public int getGuiPro(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {
		case 0:
			return ARSMod.GUI_ID_GENERATOR;
		case 1:
			return ARSMod.GUI_AREA_PROJECTOR;
		case 2:
			return ARSMod.GUI_DIRECTIONAL_PROJECTOR;
		case 3:
			return ARSMod.GUI_DEFLECTOR_PROJECTOR;
		case 4:
			return ARSMod.GUI_TUBE_PROJECTOR;
		case 5:
			return ARSMod.GUI_DIRECTIONAL_UPGRADE;
		default:
			return -1;
		}
	}

	public int getGuiUp(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {

		case 0:
			return ARSMod.GUI_REACTOR_MONITOR_CLIENT;
		case 7:
			return ARSMod.GUI_CAMOFLAGE_UPGRADE;
		default:
			return -1;
		}
	}

	@Override
	public boolean isProvidingStrongPower(IBlockAccess world, int i, int j, int k, int l) {
		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityReaktorConnector) {

			if (((TileEntityReaktorConnector) tileentity).isredpowert()) {

				switch (l) {

				case 0:
					if (world.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 1:

					if (world.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 2:
					if (world.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				case 3:
					if (world.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReactorChamber) {
						return true;
					}

					break;
				case 4:
					if (world.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				case 5:
					if (world.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReactorChamber) {
						return true;
					}
					break;
				default:
					return false;

				}

			}

		}

		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			if (((TileEntityReaktorMonitorClient) tileentity).isSignal()) {
				switch (l) {

				case 0:
					if (world.getBlockTileEntity(i, j + 1, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 1:

					if (world.getBlockTileEntity(i, j - 1, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 2:
					if (world.getBlockTileEntity(i, j, k + 1) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				case 3:
					if (world.getBlockTileEntity(i, j, k - 1) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}

					break;
				case 4:
					if (world.getBlockTileEntity(i + 1, j, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				case 5:
					if (world.getBlockTileEntity(i - 1, j, k) instanceof TileEntityReaktorMonitorClient) {
						return false;
					}
					break;
				}

				return true;
			}
		}

		return false;
	}

	@Override
	public boolean isProvidingWeakPower(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		return isProvidingStrongPower(iblockaccess, i, j, k, l);
	}

	@Override
	public boolean canProvidePower() {

		return true;
	}

	@Override
	public void breakBlock(World world, int i, int j, int k, int par5, int par6) {
		if(world.isRemote)
			return;

		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			ItemStack itemstack = ((TileEntityReaktorMonitorClient) tileentity).getStackInSlot(0);
			if (itemstack != null) {
				world.spawnEntityInWorld(new EntityItem(world, i + 0.5f, j + 0.5f, k + 0.5f, itemstack));
			}
		}

		world.removeBlockTileEntity(i, j, k);
	}

	@Override
	public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
	
		int gui = getGuiUp(world, i, j, k, entityplayer);
		int meta = world.getBlockMetadata(i, j, k);

		if (gui < 0 && meta != 4 && meta != 5) {
			return false;
		}

		if (entityplayer.isSneaking())
			return false;

		if (entityplayer.getCurrentEquippedItem() != null && (entityplayer.getCurrentEquippedItem().getItem() instanceof ItemMFD)) {
			return false;
		}

		if (gui >= 0) {
			if(!world.isRemote)
				entityplayer.openGui(ARSMod.instance, gui, world, i, j, k);
			return true;
		}

		if (meta == 4 || meta == 5) {
			TileUpgradePassive tileentity = (TileUpgradePassive) world.getBlockTileEntity(i, j, k);
			if (tileentity.getconectet_ID() != 0) {
				TileEntityGeneratorCore tileentitygen = Linkgrid.getWorldMap(world).getGenerator().get(tileentity.getconectet_ID());
				if (tileentitygen != null && !world.isRemote) {
					int guiid = getGuiPro(world, tileentitygen.xCoord, tileentitygen.yCoord, tileentitygen.zCoord, entityplayer);
					if(guiid >= 0)
						entityplayer.openGui(ARSMod.instance, gui, world, tileentitygen.xCoord, tileentitygen.yCoord, tileentitygen.zCoord);
				}
			}
		}
		return false;
	}

	@Override
	public TileEntityMaschines createNewTileEntity(World w) {
		return null;
	}

	@Override
	public int damageDropped(int i) {
		return i;

	}

	@Override
	public TileEntityMaschines createNewTileEntity(World w, int i) {
		switch (i) {
		case 0:
			return new TileEntityReaktorMonitorClient();
		case 1: // '\\ Projektor Subwater'
		case 2: // '\\ Projektor Dome'
		case 3: // '\\ Projektor Hardner'
		case 4: // '\\ Generator Array'
		case 5: // '\\ Generator Storage'
		case 6: // '\\ Projektor Zapper'
		case META_INHIBITOR:
			return new TileUpgradePassive();
		case 7: // '\\ Projektor camouflage'
			return new TileUpgradeCamouflage();
		case 8: // '\\ Reaktor Connector'
			return new TileEntityReaktorConnector();
		}
		return null;
	}

	@Override
	public String getTextureFile() {

		return "/immibis/ars/textures/upgrades.png";
	}

	public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);

		if (tileentity instanceof TileEntityReaktorMonitorClient) {
			if (((TileEntityReaktorMonitorClient) tileentity).isSignal()) {
				return true;
			} else {
				return false;
			}

		}

		if (tileentity instanceof TileUpgradePassive) {
			return ((TileUpgradePassive) tileentity).getconectet_ID() != 0;
		} else {
			return false;
		}
	}

	@Override
	public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
		int meta = iblockaccess.getBlockMetadata(i, j, k);
		
		if(l < 2) l ^= 1; // swaps top and bottom

		if (isActive(iblockaccess, i, j, k)) {
			return (meta * 16) + 7 + l;
		} else {
			return (meta * 16) + l;
		}
	}

	@Override
	public int getBlockTextureFromSideAndMetadata(int i, int j) {

		return (j * 16) + i - 1;
	}

	@Override
	public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
		TileEntity tileentity = world.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileUpgradePassive) {
			((TileUpgradePassive) tileentity).updatecheck();
		}
	}

	@Override
	public float getExplosionResistance(Entity entity, World world, int i, int j, int k, double d, double d1, double d2) {
		if (world.getBlockTileEntity(i, j, k) instanceof TileEntityMaschines) {
			TileEntity tileentity = world.getBlockTileEntity(i, j, k);
			if (((TileEntityMaschines) tileentity).getActive()) {
				return 60000F;
			} else {
				return 50F;
			}
		}
		return 50F;
	}
	
	@Override
	public final void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		for(int k = 0; k < MAX_META; k++)
			par3List.add(new ItemStack(this, 1, k));
	}

}
