package immibis.ars;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiCamouflageUpgrade extends GuiContainer {

	private TileUpgradeCamouflage inventory;

	public GuiCamouflageUpgrade(EntityPlayer inventoryplayer, TileUpgradeCamouflage tileEntity_Camoflage_Upgrade) {

		super(new ContainerCamoflage(inventoryplayer, tileEntity_Camoflage_Upgrade));
		inventory = tileEntity_Camoflage_Upgrade;

	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		int textur = mc.renderEngine.getTexture("/immibis/ars/textures/camo.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(textur);
		int w = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		drawTexturedModalRect(w, k, 0, 0, xSize, ySize);
	}

	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {

		fontRenderer.drawString("Camouflage upgrade", 5, 5, 0x404040);

		fontRenderer.drawString("Block pattern:", 20, 35, 0x404040);

		if (ARSMod.idtotextur.containsKey(inventory.getItem_ID())) {
			fontRenderer.drawString("OK", 140, 35, 0x404040);
		}

	}

}
