package immibis.ars;

import immibis.ars.projectors.TileProjectorReactor;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiReaktorField extends GuiContainer {

	private TileProjectorReactor inventory;
	
	public GuiReaktorField(EntityPlayer inventoryplayer, TileProjectorReactor tileEntityReaktorField) {

		super(new ContainerProjektor(inventoryplayer, tileEntityReaktorField));
		inventory = tileEntityReaktorField;

	}

	@SuppressWarnings("unchecked")
	@Override
	public void initGui() {

		controlList.add(new GuiButton(0, (width / 2) + 35, (height / 2) + 20, 40, 10, "change"));

		super.initGui();
	}
	
	@Override
	protected void actionPerformed(GuiButton guibutton) {
		((ContainerMFFS)inventorySlots).sendButtonPressed(guibutton.id);
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		int textur = mc.renderEngine.getTexture("/immibis/ars/textures/GUIid.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(textur);
		int w = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		drawTexturedModalRect(w, k, 0, 0, xSize, ySize);

		int i1 = (69 * inventory.getLinkPower()) / inventory.getMaxlinkPower();
		drawTexturedModalRect(w + 93, k + 30, 176, 0, i1 + 1, 69);

	}

	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {

		fontRenderer.drawString("Reactor containment field", 10, 5, 0x404040);
		fontRenderer.drawString("Force power", 10, 30, 0x404040);
		fontRenderer.drawString("available", 22, 40, 0x404040);
		fontRenderer.drawString("Linked to core:", 10, 60, 0x404040);
		fontRenderer.drawString("Linked to reactor: ", 10, 70, 0x404040);
		fontRenderer.drawString("Reactor heat: ", 10, 80, 0x404040);
		fontRenderer.drawString("Water cooling: ", 10, 90, 0x404040);
		fontRenderer.drawString("Frequency card:", 10, 123, 0x404040);

		fontRenderer.drawString((new StringBuilder()).append(" ").append(inventory.getLinkPower()).toString(), 100, 45, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(inventory.isLinkGenerator()).toString(), 120, 60, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(inventory.isIsreaktor()).toString(), 120, 70, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(inventory.getReaktorheat()).toString(), 120, 80, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(inventory.isWatercool()).toString(), 120, 90, 0x404040);

	}

}
