package immibis.ars;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiReaktorMonitorClient extends GuiContainer {

	private TileEntityReaktorMonitorClient Monitorclient;

	public GuiReaktorMonitorClient(EntityPlayer inventoryPlayer, TileEntityReaktorMonitorClient tileentity) {

		super(new ContainerReaktorMonitorClient(inventoryPlayer, tileentity));
		Monitorclient = tileentity;

	}
	
	@Override
	protected void actionPerformed(GuiButton guibutton) {
		((ContainerMFFS)inventorySlots).sendButtonPressed(guibutton.id);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void initGui() {

		controlList.add(new GuiButton(0, (width / 2) - 85, (height / 2) - 10, 55, 20, "Channel 0"));
		controlList.add(new GuiButton(1, (width / 2) - 30, (height / 2) - 10, 55, 20, "Channel 1"));
		controlList.add(new GuiButton(2, (width / 2) + 25, (height / 2) - 10, 55, 20, "Channel 2"));
		controlList.add(new GuiButton(3, (width / 2) - 85, (height / 2) + 15, 55, 20, "Channel 3"));
		controlList.add(new GuiButton(4, (width / 2) - 30, (height / 2) + 15, 55, 20, "Channel 4"));
		controlList.add(new GuiButton(5, (width / 2) + 25, (height / 2) + 15, 55, 20, "Channel 5"));

		super.initGui();
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		int textur = mc.renderEngine.getTexture("/immibis/ars/textures/GUImonitor.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(textur);
		int w = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		drawTexturedModalRect(w, k, 0, 0, xSize, ySize);

	}

	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {

		fontRenderer.drawString("Reactor monitor client", 10, 5, 0x404040);

		fontRenderer.drawString("Linked monitor:", 10, 20, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitorclient.isLinkMonitor()).toString(), 100, 20, 0x404040);

		fontRenderer.drawString((new StringBuilder()).append(" ").append(Monitorclient.getMontorname()).toString(), 10, 35, 0x404040);

		fontRenderer.drawString("Current channel:", 10, 50, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(Monitorclient.getUsechannel()).toString(), 100, 50, 0x404040);

		fontRenderer.drawString("---channel switch---", 30, 65, 0x404040);

		fontRenderer.drawString("Frequency card:", 5, 123, 0x404040);

	}

}