package immibis.ars;

import immibis.core.api.porting.SidedProxy;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemComponent extends Item {
	
	public static final int META_ENERGY_MODULATOR = 0;
	public static final int META_DIAMOND_LENS = 1;
	public static final int META_PROJECTOR_BASE = 2;
	
	private String[] internal_names;

	public ItemComponent(int id_minus256) {
		super(id_minus256);
		
		String[] names = new String[] {
			"Energy modulator",
			"Diamond lens",
			"Forcefield projector base"
		};
		
		setMaxDamage(0);
        setHasSubtypes(true);
        
        setCreativeTab(CreativeTabs.tabMisc);
        
        internal_names = new String[names.length];
        for(int k = 0; k < names.length && k < 16; k++)
        {
        	internal_names[k] = "ARS-component."+k;
        	SidedProxy.instance.addLocalization(internal_names[k] + ".name", names[k]);
        }
        
		setTextureFile("/immibis/ars/textures/items.png");
	}
	
	@Override
	public String getItemNameIS(ItemStack is) {
		try {
			return internal_names[is.getItemDamage()];
		} catch(ArrayIndexOutOfBoundsException e) {
			return "";
		}
	}
	
	@Override
	public int getIconFromDamage(int damage) {
		return 32 + damage;
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void getSubItems(int id, CreativeTabs tab, List list) {
		for(int meta = 0; meta < 3; meta++)
			list.add(new ItemStack(this, 1, meta));
	}

}
