package immibis.ars;

import immibis.ars.projectors.TileProjector;
import immibis.ars.projectors.TileProjectorArea;
import immibis.ars.projectors.TileProjectorDeflector;
import immibis.ars.projectors.TileProjectorDirectional;
import immibis.ars.projectors.TileProjectorExtender;
import immibis.ars.projectors.TileProjectorReactor;
import immibis.ars.projectors.TileProjectorTube;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import net.minecraft.src.forge.*;
import net.minecraftforge.*;
import net.minecraft.src.*;

public class BlockMachine extends BlockContainer
/* $if mc < 1.3$
implements ISpecialResistance
$endif$ */
{
	/* $if mc > 1.3$ */
	@Override
	public final void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		ArrayList al = new ArrayList();
		addCreativeItems(al);
		par3List.addAll(al);
	}
	/* $endif$ */

	public static final int META_CORE = 0;
	public static final int META_PROJ_AREA = 1;
	public static final int META_PROJ_DIR = 2;
	public static final int META_PROJ_DEFLECTOR = 3;
	public static final int META_PROJ_TUBE = 4;
	public static final int META_PROJ_EXTENDER = 5;
	public static final int META_EU_INJECTOR = 6;
	public static final int META_PROJ_REACTOR = 7;
	public static final int META_REACTOR_COOLER = 8;
	public static final int META_REACTOR_MONITOR = 9;
	
	public static final int MAX_META = 10;
	
	private int blockid;

	public BlockMachine(int i) {

		super(i, Material.iron);
		blockid = i;
		setHardness(3F);
		setResistance(50F);
		setStepSound(soundMetalFootstep);
		
		/* $if mc > 1.3$ */
		setCreativeTab(CreativeTabs.tabMisc);
		/* $endif$ */

	}

	public int getBlockid() {
		return blockid;
	}

	public int getGui(World world, int i, int j, int k, EntityPlayer entityplayer) {
		switch (world.getBlockMetadata(i, j, k)) {
		case 0:
			return mod_AdvancedRepulsionSystems.GUI_ID_GENERATOR;
		case 1:
			return mod_AdvancedRepulsionSystems.GUI_AREA_PROJECTOR;
		case 2:
			return mod_AdvancedRepulsionSystems.GUI_DIRECTIONAL_PROJECTOR;
		case 3:
			return mod_AdvancedRepulsionSystems.GUI_DEFLECTOR_PROJECTOR;
		case 4:
			return mod_AdvancedRepulsionSystems.GUI_TUBE_PROJECTOR;
		case 5:
			return mod_AdvancedRepulsionSystems.GUI_DIRECTIONAL_UPGRADE;
		case 7:
			return mod_AdvancedRepulsionSystems.GUI_REACTOR_FIELD;
		case 8:
			return mod_AdvancedRepulsionSystems.GUI_REACTOR_COOLER;
		case 9:
			return mod_AdvancedRepulsionSystems.GUI_REACTOR_MONITOR;
		default:
			return -1;
		}
	}

	@Override
	/* $if mc < 1.3$
	public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
	$else$ */
	public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
	/* $endif$ */

		if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Block.lever.blockID) {
			return false;
		}
		if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == mod_AdvancedRepulsionSystems.MFFSUpgrades.blockID) {
			return false;
		}
		if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == mod_AdvancedRepulsionSystems.MFFSMaschines.blockID) {
			return false;
		}

		if (entityplayer.getCurrentEquippedItem() != null && (entityplayer.getCurrentEquippedItem().getItem() instanceof ItemMFD)) {
			return false;
		}
		
		if(world.isRemote)
			return true;

		int gui = getGui(world, i, j, k, entityplayer);

		if(gui < 0)
			return false;

		entityplayer.openGui(mod_AdvancedRepulsionSystems.instance, gui, world, i, j, k);
		return true;
	}

	@Override
	/* $if mc < 1.3$
	public TileEntityMaschines getBlockEntity() {
	$else$ */
	public TileEntityMaschines createNewTileEntity(World world) {
	/* $endif$ */
		return null;
	}

	@Override
	public void onBlockAdded(World world, int i, int j, int k) {
		if(world.isRemote) {
			return;
		}
		int meta = world.getBlockMetadata(i, j, k);
		if (meta == 0) {
			TileEntityGeneratorCore tileentityblock = (TileEntityGeneratorCore) world.getBlockTileEntity(i, j, k);
			tileentityblock.addtogrid();
		}
		if (meta == 1) {
			TileProjectorArea tileentityblock = (TileProjectorArea) world.getBlockTileEntity(i, j, k);
			tileentityblock.addtogrid();
		}
		if (meta == 2) {
			TileProjectorDirectional tileentityblock = (TileProjectorDirectional) world.getBlockTileEntity(i, j, k);
			tileentityblock.addtogrid();
		}
		if (meta == 3) {
			TileProjectorDeflector tileentityblock = (TileProjectorDeflector) world.getBlockTileEntity(i, j, k);
			tileentityblock.addtogrid();
		}
		if (meta == 4) {
			TileProjectorTube tileentityblock = (TileProjectorTube) world.getBlockTileEntity(i, j, k);
			tileentityblock.addtogrid();
		}
		if (meta == 7) {
			TileProjectorReactor tileentityblock = (TileProjectorReactor) world.getBlockTileEntity(i, j, k);
			tileentityblock.addtogrid();
		}

	}

	@Override
	/* $if mc < 1.3$
	public void onBlockRemoval(World world, int i, int j, int k) {
	$else$ */
	public void breakBlock(World world, int i, int j, int k, int par5, int par6) {
	/* $endif$ */
		if(world.isRemote) {
			return;
		}
		
		TileEntity te = world.getBlockTileEntity(i, j, k);
		
		if(te instanceof TileEntityGeneratorCore) {
			((TileEntityGeneratorCore)te).removefromgrid();
		} else if(te instanceof TileProjector) {
			((TileProjector)te).destroyField();
			((TileProjector)te).removefromgrid();
		} else if(te instanceof TileEntityReaktorMonitor) {
			((TileEntityReaktorMonitor)te).removefromgrid();
		}

		if (te instanceof TileProjector) {
			ItemStack itemstack = ((TileProjector) te).getStackInSlot(0);
			if (itemstack != null) {
				world.spawnEntityInWorld(new EntityItem(world, i + 0.5f, j + 0.5f, k + 0.5f, itemstack));
			}
		}

		world.removeBlockTileEntity(i, j, k);

	}

	@Override
	public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
		if(world.isRemote) {
			return;
		}

		TileEntityMaschines tileentityblock = (TileEntityMaschines) world.getBlockTileEntity(i, j, k);

		int l = MathHelper.floor_double((double) ((entityliving.rotationYaw * 4F) / 360F) + 0.5D) & 3;
		int i1 = Math.round(entityliving.rotationPitch);
		if (i1 >= 65) {
			tileentityblock.setFacing((short) 1);
		} else if (i1 <= -65) {
			tileentityblock.setFacing((short) 0);
		} else if (l == 0) {
			tileentityblock.setFacing((short) 2);
		} else if (l == 1) {
			tileentityblock.setFacing((short) 5);
		} else if (l == 2) {
			tileentityblock.setFacing((short) 3);
		} else if (l == 3) {
			tileentityblock.setFacing((short) 4);
		}
	}

	@Override
	protected int damageDropped(int i) {
		return i;

	}

	@Override
	/* $if mc < 1.3$
	public TileEntityMaschines getBlockEntity(int i) {
	$else$ */
	public TileEntityMaschines createNewTileEntity(World world, int i) {
	/* $endif$ */
		switch (i) {
		case 0:
			return new TileEntityGeneratorCore();
		case 1:
			return new TileProjectorArea();
		case 2:
			return new TileProjectorDirectional();
		case 3:
			return new TileProjectorDeflector();
		case 4:
			return new TileProjectorTube();
		case 5:
			return new TileProjectorExtender();
		case 6:
			return new TileEntityGeneratorEUInjector();
		case 7:
			return new TileProjectorReactor();
		case 8:
			return new TileEntityReaktorCooler();
		case 9:
			return new TileEntityReaktorMonitor();
		}
		return null;
	}

	@Override
	public String getTextureFile() {

		return "/mffs_grafik/machines.png";
	}

	public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
		if (tileentity instanceof TileEntityMaschines) {
			return ((TileEntityMaschines) tileentity).getActive();
		} else {
			return false;
		}
	}

	/* $if jclient$ */
	@Override
	/* $endif$ */
	public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
		short facing = (tileentity instanceof TileEntityMaschines) ? ((TileEntityMaschines) tileentity).getFacing() : 0;
		int meta = iblockaccess.getBlockMetadata(i, j, k);

		if (isActive(iblockaccess, i, j, k)) {
			if (facing == l) {
				return (meta * 16) + 7;
			}
			if (facing != 0 && l == 0) {
				return (meta * 16) + 7 + 1;
			}
			return (meta * 16) + 7 + l;

		} else {
			if (facing == l) {
				return (meta * 16);
			}
			if (facing != 0 && l == 0) {
				return (meta * 16) + 1;
			}
			return (meta * 16) + l;
		}
	}

	@Override
	public int getBlockTextureFromSideAndMetadata(int i, int j) {

		return (j * 16) + i - 1;
	}

	@Override
	/* $if mc < 1.3$
	public float getSpecialExplosionResistance(World world, int i, int j, int k, double d, double d1, double d2, Entity entity) {
	$else$ */
	public float getExplosionResistance(Entity entity, World world, int i, int j, int k, double d, double d1, double d2) {
	/* $endif$ */

		if (world.getBlockTileEntity(i, j, k) instanceof TileEntityMaschines) {
			TileEntity tileentity = world.getBlockTileEntity(i, j, k);
			if (((TileEntityMaschines) tileentity).getActive()) {
				return 60000F;
			} else {
				return 50F;
			}
		}
		return 50F;
	}
	
	@Override
	public void addCreativeItems(ArrayList l) {
		for(int k = 0; k < MAX_META; k++)
			l.add(new ItemStack(this, 1, k));
	}

}
