package immibis.ars;

import immibis.core.net.TESync;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet132TileEntityData;
import net.minecraft.src.TileEntity;

public class TileCamouflagedField extends TileEntity {
	public int camoBlockId = -1;
	
	/* $if jserver$ */
	@Override
	/* $endif$ */
	public Packet getDescriptionPacket() {
		return TESync.make132(xCoord, yCoord, zCoord, camoBlockId, 0, 0);
	}
	
	@Override
	public void onDataPacket(NetworkManager net, Packet132TileEntityData p) {
		camoBlockId = TESync.getFirst(p);
	}
	
	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		nbt.setInteger("camo", camoBlockId);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		camoBlockId = nbt.getInteger("camo");
	}
}
