package immibis.ars;

import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.TileEntity;
import immibis.core.api.porting.PortableBlockRenderer;
import immibis.core.aspects.ClientOnly;
import net.minecraftforge.client.ForgeHooksClient;

@ClientOnly
public class BlockRendererField implements PortableBlockRenderer {
	@Override
	public boolean renderWorldBlock(RenderBlocks rb, IBlockAccess w, int x, int y, int z, Block b, int model) {
		if(b == mod_AdvancedRepulsionSystems.MFFSFieldblock) {
			int meta = w.getBlockMetadata(x, y, z);
			
			boolean usingCamo = false;
			
			if(BlockForceField.isCamo(meta))
			{
				TileEntity te = w.getBlockTileEntity(x, y, z);
				if(te != null)
				{
					int camoBlock = ((TileCamouflagedField)te).camoBlockId;
					BlockForceField.useTextures = mod_AdvancedRepulsionSystems.idtotextur.get(camoBlock);
					usingCamo = (BlockForceField.useTextures != null);
					//System.out.println("camoblock "+camoBlock+", textures "+BlockForceField.useTextures);
				}
			}
			
			if(!usingCamo)
			{
				ForgeHooksClient.bindTexture("/immibis/ars/textures/blocks.png", 0);
				rb.renderStandardBlock(b, x, y, z);
				ForgeHooksClient.unbindTexture();
			}
			else
			{
				rb.renderStandardBlock(b, x, y, z);
				BlockForceField.useTextures = null;
			}
			
			return true;
		}
		return false;
	}
	
	@Override
	public void renderInvBlock(RenderBlocks rb, Block b, int meta, int model) {
		// field blocks shouldn't be in inventories - let them be invisible
	}
}

/* $endif$ */