package immibis.ars;

import immibis.core.BasicInventory;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;

public class ContainerReaktorMonitorClient extends ContainerMFFS {

	private TileEntityReaktorMonitorClient ReaktorMonitorClient;

	public ContainerReaktorMonitorClient(EntityPlayer player, TileEntityReaktorMonitorClient tileentity) {
		
		super(player, tileentity);

		ReaktorMonitorClient = tileentity;
		addSlotToContainer(new Slot(ReaktorMonitorClient, 0, 97, 120));

		for (int j = 0; j < 9; j++) {
			addSlotToContainer(new Slot(player.inventory, j, 8 + j * 18, 142));
		}

	}

	@Override
	public void onCraftGuiClosed(EntityPlayer entityplayer) {
		super.onCraftGuiClosed(entityplayer);
		entityplayer.openContainer.updateCraftingResults();

	}

	@Override
	public ItemStack transferStackInSlot(int i) {
		if(i == 0) {
			BasicInventory.mergeStackIntoRange(inv, player.inventory, 0, 0, 9);
		} else {
			BasicInventory.mergeStackIntoRange(player.inventory, inv, i - 1, 0, 1);
		}
		return null;
	}

}