package immibis.ars;

import immibis.core.api.porting.SidedProxy;

import java.io.File;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraftforge.common.*;

import java.util.logging.Logger;

public class Functions {

	private final static Logger log = Logger.getLogger("Client");

	public static void DisplayInfo(String s) {
		log.info(s);
	}

	public static File getMinecraftDir() {
		return SidedProxy.instance.getMinecraftDir();
	}

	public static int getBlockIdFor(String s, int i) {
		if (mod_AdvancedRepulsionSystems.config == null) {
			return i;
		}
		return mod_AdvancedRepulsionSystems.config.get("1", s, i).getInt(i);
	}

	public static int getItemIdFor(String s, int i) {
		if (mod_AdvancedRepulsionSystems.config == null) {
			return i;
		}
		return mod_AdvancedRepulsionSystems.config.get("2", s, i).getInt(i);
	}

	public static void ChattoPlayer(EntityPlayer player, String Message) {
		SidedProxy.instance.sendChat(Message, player);
	}

	public static NBTTagCompound getTAGfromItemstack(ItemStack itemStack) {
		NBTTagCompound tag = itemStack.getTagCompound();
		if (tag == null) {
			tag = new NBTTagCompound();
			itemStack.setTagCompound(tag);
		}
		return tag;
	}

	public static boolean getConfigBoolean(String key, boolean def) {
		return mod_AdvancedRepulsionSystems.config.get(Configuration.CATEGORY_GENERAL, key, def).getBoolean(def);
	}

	public static int getBalanceOption(String key, int def) {
		return mod_AdvancedRepulsionSystems.config.get(Configuration.CATEGORY_GENERAL, key, def).getInt(def);
	}

}
