package immibis.ars;

import immibis.ars.ContainerReactorCooler;
import immibis.ars.TileEntityReaktorCooler;
import immibis.core.aspects.ClientOnly;
import immibis.core.net.AbstractSyncedContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;

import org.lwjgl.opengl.GL11;

@ClientOnly
public class GuiReaktorCooler extends GuiContainer {

	private TileEntityReaktorCooler inventory;

	public GuiReaktorCooler(EntityPlayer inventoryplayer, TileEntityReaktorCooler tileEntityReaktorControl) {

		super(new ContainerReactorCooler(inventoryplayer, tileEntityReaktorControl));
		inventory = tileEntityReaktorControl;

	}

	@Override
	protected void actionPerformed(GuiButton guibutton) {
		((AbstractSyncedContainer)inventorySlots).sendButtonPressed(guibutton.id);
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		int textur = mc.renderEngine.getTexture("/immibis/ars/textures/reaktorcooler.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(textur);
		int w = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		drawTexturedModalRect(w, k, 0, 0, xSize, ySize);

	}

	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {

		fontRenderer.drawString("Reactor coolant injector", 20, 8, 0x404040);

		fontRenderer.drawString("Heat:", 10, 30, 0x404040);
		fontRenderer.drawString("Max heat:", 10, 45, 0x404040);

		fontRenderer.drawString((new StringBuilder()).append(inventory.getHeat()).toString(), 120, 30, 0x404040);
		fontRenderer.drawString((new StringBuilder()).append(inventory.getMaxheat()).toString(), 120, 45, 0x404040);

	}

}