package immibis.ars;

import immibis.core.api.porting.PortableTileEntity;
import immibis.core.net.TESync;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet132TileEntityData;

public class TileCamouflagedField extends PortableTileEntity {
	public int camoBlockId = -1;
	
	@Override
	public Packet getDescriptionPacket() {
		return TESync.make132(xCoord, yCoord, zCoord, camoBlockId, 0, 0);
	}
	
	@Override
	public void onDataPacket(Packet132TileEntityData p) {
		camoBlockId = TESync.getFirst(p);
	}
	
	@Override
	public void writeToNBT(NBTTagCompound nbt) {
		super.writeToNBT(nbt);
		nbt.setInteger("camo", camoBlockId);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		camoBlockId = nbt.getInteger("camo");
	}
}
