package immibis.ars.beams;

import immibis.core.aspects.ClientOnly;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.src.CreativeTabs;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;

public class ItemLogicCard extends Item {
	public ItemLogicCard(int id_minus_256) {
		super(id_minus_256);
		
		setTextureFile("/immibis/ars/textures/tesla.png");
		
		setHasSubtypes(true);
		
		LogicType.init();
		
		setCreativeTab(net.minecraft.src.CreativeTabs.tabMisc);
	}
	
	@Override
	public String getItemNameIS(ItemStack is) {
		return "immibis.ars.logiccard."+is.getItemDamage();
	}
	
	@Override
	public int getIconFromDamage(int meta) {
		return 32 + meta;
	}
	
	@Override
	public void getSubItems(int id, CreativeTabs tab, List list) {
		for(int meta : LogicType.getAllTypeIDs())
			list.add(new ItemStack(this, 1, meta));
	}
}
