package immibis.ars.projectors;

import ic2.common.TileEntityNuclearReactor;
import ic2.common.TileEntityReactorChamber;
import immibis.ars.BlockMachine;
import immibis.ars.Linkgrid;
import immibis.ars.TileEntityGeneratorCore;
import immibis.ars.TileEntityReaktorCooler;
import immibis.ars.TileEntityReaktorMonitor;
import immibis.ars.TileUpgradePassive;
import immibis.ars.mod_AdvancedRepulsionSystems;

import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;

public class TileProjectorReactor extends TileProjector {

	private boolean watercool;
	private boolean isreaktor;
	private int reactorx = 0;
	private int reactory = 0;
	private int reactorz = 0;
	private int reactordist = 0;
	private int reactorsize = 0;
	private int reactorheat;
	private int maxheat;
	
	@Override
	public int[] getUpdate() {
		return new int[] {watercool?1:0, isreaktor?1:0, reactorx, reactory, reactorz, reactordist, reactorsize, reactorheat, maxheat}; 
	}

	@Override
	public void handleUpdate(int[] p) {
		watercool = p[0] != 0;
		isreaktor = p[1] != 0;
		reactorx = p[2];
		reactory = p[3];
		reactorz = p[4];
		reactordist = p[5];
		reactorsize = p[6];
		reactorheat = p[7];
		maxheat = p[8];
	}
	
	@Override
	public void handleButton(int id) {
		if(!getActive() && id == 0)
			setWatercool(!isWatercool());
	}

	public TileProjectorReactor() {

		isreaktor = false;
		reactorheat = 0;
		watercool = false;
		
		specialffmeta = (short)3;

	}

	public int getReactorx() {
		return reactorx;
	}

	public int getReactory() {
		return reactory;
	}

	public int getReactorz() {
		return reactorz;
	}

	public int getReactordist() {
		return reactordist;
	}

	public int getReactorsize() {
		return reactorsize;
	}

	public int getReactorheat() {
		return reactorheat;
	}

	public boolean isWatercool() {
		return watercool;
	}

	public void setWatercoolinit(boolean watercool) {

		this.watercool = watercool;
		updateCount++;
	}

	public void setWatercool(boolean watercool) {
		this.watercool = watercool;
		updateCount++;
	}

	public int getReaktorheat() {
		return reactorheat;
	}

	public void setReaktorheat(int reaktorheat) {
		this.reactorheat = reaktorheat;
		updateCount++;
	}

	public boolean isIsreaktor() {
		return isreaktor;
	}

	public void setIsreaktor(boolean isreaktor) {
		this.isreaktor = isreaktor;
		updateCount++;
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);
		watercool = nbttagcompound.getBoolean("watercool");

	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {

		super.writeToNBT(nbttagcompound);
		nbttagcompound.setBoolean("watercool", watercool);

	}

	private boolean scanforNuclearReaktor() {

		for (int x = xCoord - 2; x <= xCoord + 2; x++) {
			for (int y = yCoord - 2; y <= yCoord + 2; y++) {
				for (int z = zCoord - 2; z <= zCoord + 2; z++) {

					TileEntity tileEntity = worldObj.getBlockTileEntity(x, y, z);

					if (tileEntity instanceof TileEntityNuclearReactor) {
						reactorx = x;
						reactory = y;
						reactorz = z;

						if (Math.abs(xCoord - reactorx) <= 1 && Math.abs(yCoord - reactory) <= 1 && Math.abs(zCoord - reactorz) <= 1) {
							reactordist = 1;
						} else {
							reactordist = 2;
						}

						return true;
					}
				}
			}
		}
		return false;
	}

	private int scanforReaktorCamber() {

		int chamber = 0;

		if (worldObj.getBlockTileEntity(reactorx + 1, reactory, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx - 1, reactory, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory + 1, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory - 1, reactorz) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory, reactorz + 1) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		if (worldObj.getBlockTileEntity(reactorx, reactory, reactorz - 1) instanceof TileEntityReactorChamber) {
			chamber++;
		}
		return chamber;

	}
	
	@Override
	public boolean overrideActivationStatus(boolean activate) {
		if(!isIsreaktor()) {
			hardner = false;
			return false;
		}

		switch (reactorsize) {
		case 0:
			maxheat = 7500;
			break;
		case 1:
			maxheat = 8350;
			break;
		case 2:
			maxheat = 9200;
			break;
		case 3:
			maxheat = 10050;
			break;
		case 4:
			maxheat = 10900;
			break;
		case 5:
			maxheat = 11750;
			break;
		case 6:
			maxheat = 12600;
			break;
		}

		if (maxheat < reactorheat) {
			hardner = true;
			activate = true;
		}
		
		if(!getActive()) {
			if(reactorsize >= 1 && reactordist < 2)
				activate = false;
		}
		
		if(!activate)
			hardner = false;
		
		return activate;
	}
	
	@Override
	public void onEveryTick() {
		if(!isIsreaktor())
			setIsreaktor(scanforNuclearReaktor());
	}
	
	@Override
	public void onFieldTick() {
		if (isreaktor) {
			reactorsize = scanforReaktorCamber();
			TileEntity tileEntity = worldObj.getBlockTileEntity(reactorx, reactory, reactorz);

			if (tileEntity instanceof TileEntityNuclearReactor) {
				setReaktorheat(((TileEntityNuclearReactor) tileEntity).heat);
				if (getActive()) {
					refreshwater();
				}

			} else {

				setIsreaktor(false);

			}
		}
	}

	public void refreshwater() {
		if(!watercool)
			return;
		TileEntity generatorTE = Linkgrid.getWorldMap(worldObj).getGenerator().get(this.getLinkGenerator_ID());
		if(!(generatorTE instanceof TileEntityGeneratorCore))
			return;
		TileEntityGeneratorCore gen = (TileEntityGeneratorCore)generatorTE;
		for (int y1 = 0 - reactordist; y1 <= reactordist; y1++) {
			for (int x1 = 0 - reactordist; x1 <= reactordist; x1++) {
				for (int z1 = 0 - reactordist; z1 <= reactordist; z1++) {
					if (worldObj.getBlockId(reactorx + x1, reactory + y1, reactorz + z1) == 0) {
						worldObj.setBlockWithNotify(reactorx + x1, reactory + y1, reactorz + z1, 8);
						gen.Energylost(1000);
					}
				}
			}
		}
	}
	
	@Override
	public void onActivateProjector() {
		if(watercool)
			refreshwater();
	}
	
	@Override
	public void onDeactivateProjector() {
		if (watercool) {
			for (int y1 = 0 - reactordist; y1 <= reactordist; y1++) {
				for (int x1 = 0 - reactordist; x1 <= reactordist; x1++) {
					for (int z1 = 0 - reactordist; z1 <= reactordist; z1++) {

						if (worldObj.getBlockMaterial(reactorx + x1, reactory + y1, reactorz + z1).isLiquid()) {
							worldObj.setBlockWithNotify(reactorx + x1, reactory + y1, reactorz + z1, 0);

						}

					}
				}
			}
		}
	}

	/*@Override
	protected void getFieldShape(CoordinateList shape) {
		for (int y1 = 0 - reactordist; y1 <= reactordist; y1++) {
			for (int x1 = 0 - reactordist; x1 <= reactordist; x1++) {
				for (int z1 = 0 - reactordist; z1 <= reactordist; z1++) {
					if (x1 == 0 - reactordist || x1 == reactordist || y1 == 0 - reactordist || y1 == reactordist || z1 == 0 - reactordist || z1 == reactordist) {
						shape.add(reactorx + x1, reactory + y1, reactorz + z1);
					}
				}
			}
		}
	}*/
	
	@Override
	protected FFShape getFieldShape() {
		offsetX = reactorx - xCoord;
		offsetY = reactory - yCoord;
		offsetZ = reactorz - zCoord;
		return new FFShapeCube(this, reactordist);
	}

	@Override
	public void checkupgrades() {

		for (int x = 0 - 2; x <= 2; x++) {
			for (int y = 0 - 2; y <= 2; y++) {
				for (int z = 0 - 2; z <= 2; z++) {

					int blockID = worldObj.getBlockId(reactorx + x, reactory + y, reactorz + z);
					int meta = worldObj.getBlockMetadata(reactorx + x, reactory + y, reactorz + z);
					
					if(blockID == mod_AdvancedRepulsionSystems.MFFSMaschines.blockID && meta == BlockMachine.META_REACTOR_COOLER) {
						TileEntityReaktorCooler rc = (TileEntityReaktorCooler)worldObj.getBlockTileEntity(reactorx + x, reactory + y, reactorz + z);
						
						if(rc.getconectet_ID() == 0) {
							rc.setconectet_ID(getProjektor_ID());
							rc.setConnectet_typID((short) 2);
							worldObj.markBlockForUpdate(rc.xCoord, rc.yCoord, rc.zCoord);
						}

						if(rc.getconectet_ID() == getProjektor_ID() && rc.getConnectet_typID() == 2) {
							rc.setActive(this.getActive());
							rc.setIsreaktor(this.isIsreaktor());
							rc.setMaxheat(this.maxheat);
							rc.setReaktorx(this.reactorx);
							rc.setReaktory(this.reactory);
							rc.setReaktorz(this.reactorz);
						}
					}

					if (blockID == mod_AdvancedRepulsionSystems.MFFSMaschines.blockID && meta == BlockMachine.META_REACTOR_MONITOR) {
						
						TileEntityReaktorMonitor rm = (TileEntityReaktorMonitor)worldObj.getBlockTileEntity(reactorx + x, reactory + y, reactorz + z);

						if(rm.getconectet_ID() == 0) {
							rm.setconectet_ID(getProjektor_ID());
							rm.setConnectet_typID((short) 2);
							worldObj.markBlockForUpdate(rm.xCoord, rm.yCoord, rm.zCoord);
						}

						if (rm.getconectet_ID() == getProjektor_ID() && rm.getConnectet_typID() == 2) {
							
							rm.setActive(this.getActive());
							rm.setIsreaktor(this.isIsreaktor());
							rm.setReaktorx(this.reactorx);
							rm.setReaktory(this.reactory);
							rm.setReaktorz(this.reactorz);
							rm.setMaxheat(this.maxheat);
						}

					}

				}
			}
		}
		
		setffmeta((short)3);

	}

	@Override
	public ItemStack getStackInSlotOnClosing(int var1) {
		return null;
	}

	@Override
	public int estimateBlockCount() {
		return reactordist * reactordist * 24;
	}
}