package immibis.ars.beams;

import immibis.core.api.porting.PortableContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;

public class ContainerUpgradeUnit extends PortableContainer {

	public ContainerUpgradeUnit(EntityPlayer player, TileUpgradeUnit inv) {
		super(player, inv);
		
		for(int x = 0; x < 9; x++)
			addSlot(new Slot(player.inventory, x, 8 + 18*x, 198));
		
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlot(new Slot(player.inventory, x + y*9 + 9, 8 + 18*x, 140 + 18*y));
		
		for(int y = 0; y < 6; y++)
			addSlot(new Slot(inv, y + TileUpgradeUnit.SLOT_COL1, 12, 13 + 20*y));
		
		for(int y = 0; y < 3; y++)
			addSlot(new Slot(inv, y + TileUpgradeUnit.SLOT_COL2, 55, 23 + 40*y));
		
		addSlot(new Slot(inv, TileUpgradeUnit.SLOT_COL3, 109, 63));
		addSlot(new Slot(inv, TileUpgradeUnit.SLOT_FINAL, 151, 63));
	}
	
	@Override
	public ItemStack transferStackInSlot(int slot) {
		return null;
	}

}
