package immibis.core;

import immibis.core.microblock.CoverSystemProxy;

import java.util.Collection;

import codechicken.nei.api.IConfigureNEI;
import cpw.mods.fml.common.Loader;

public class NEIImmibisCoreConfig implements IConfigureNEI {
	@Override
	public void loadConfig() {
		if(ImmibisCore.coversEnabled) {
			try {
				Class.forName("codechicken.nei.api.API")
					.getDeclaredMethod("setItemDamageVariants", int.class, Collection.class)
					.invoke(null, CoverSystemProxy.blockMultipart.blockID, CoverSystemProxy.parts.keySet());
			} catch(Throwable e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public String getName() {
		return "Immibis Core";
	}

	@Override
	public String getVersion() {
		return Loader.instance().getReversedModObjectList().get(ImmibisCore.instance).getVersion();
	}
}
