package immibis.core.microblock;

import immibis.core.BlockMetaPair;
import immibis.core.Config;
import immibis.core.ImmibisCore;
import immibis.core.api.APILocator;
import immibis.core.api.IIDCallback;
import immibis.core.api.net.IPacket;
import immibis.core.api.net.IPacketMap;
import immibis.core.api.porting.SidedProxy;
import immibis.core.microblock.recipes.RecipeCombineSeveral;
import immibis.core.microblock.recipes.RecipeCombineTwo;
import immibis.core.microblock.recipes.RecipeHollowCover;
import immibis.core.microblock.recipes.RecipeHorizontalCut;
import immibis.core.microblock.recipes.RecipeUnHollowCover;
import immibis.core.microblock.recipes.RecipeVerticalCut;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

public class CoverSystemProxy {
	static int coverModel;
	public static BlockMicroblockContainer blockMultipart;
	public static ItemSaw itemSaw;
	public final static HashMap<Integer, PartType> parts = new HashMap<Integer, PartType>();
	
	public static final String CHANNEL = "ImmibisMicro";
	public static final byte PKT_S2C_MICROBLOCK_CONTAINER_DESCRIPTION = 0;
	
	public static ArrayList<Integer> neiDamageValues = new ArrayList<Integer>();
	public static int neiMaxDamage = 0;
	
	public static void ModsLoaded() {
		RegisterPartsBasedOnBlock(1, Block.stone);
		//RegisterPartsBasedOnBlock(2, Block.grass);
		RegisterPartsBasedOnBlock(3, Block.dirt);
		RegisterPartsBasedOnBlock(4, Block.cobblestone);
		RegisterPartsBasedOnBlock(5, Block.planks, 0);
		RegisterPartsBasedOnBlock(6, Block.planks, 1);
		RegisterPartsBasedOnBlock(7, Block.planks, 2);
		RegisterPartsBasedOnBlock(8, Block.planks, 3);
		RegisterPartsBasedOnBlock(9, Block.bedrock);
		RegisterPartsBasedOnBlock(10, Block.sand);
		RegisterPartsBasedOnBlock(11, Block.gravel);
		RegisterPartsBasedOnBlock(12, Block.oreGold);
		RegisterPartsBasedOnBlock(13, Block.oreIron);
		RegisterPartsBasedOnBlock(14, Block.oreCoal);
		RegisterPartsBasedOnBlock(15, Block.wood, 0);
		RegisterPartsBasedOnBlock(16, Block.wood, 1);
		RegisterPartsBasedOnBlock(17, Block.wood, 2);
		RegisterPartsBasedOnBlock(18, Block.wood, 3);
		//RegisterPartsBasedOnBlock(19, Block.leaves, 0);
		//RegisterPartsBasedOnBlock(20, Block.leaves, 1);
		//RegisterPartsBasedOnBlock(21, Block.leaves, 2);
		//RegisterPartsBasedOnBlock(22, Block.leaves, 3);
		RegisterPartsBasedOnBlock(23, Block.sponge);
		RegisterPartsBasedOnBlock(24, Block.glass);
		RegisterPartsBasedOnBlock(25, Block.oreLapis);
		RegisterPartsBasedOnBlock(26, Block.blockLapis);
		RegisterPartsBasedOnBlock(27, Block.dispenser);
		RegisterPartsBasedOnBlock(28, Block.sandStone);
		RegisterPartsBasedOnBlock(29, Block.music);
		RegisterPartsBasedOnBlock(30, Block.pistonStickyBase);
		RegisterPartsBasedOnBlock(31, Block.pistonBase);
		RegisterPartsBasedOnBlock(32, Block.cloth, 0);
		RegisterPartsBasedOnBlock(33, Block.cloth, 1);
		RegisterPartsBasedOnBlock(34, Block.cloth, 2);
		RegisterPartsBasedOnBlock(35, Block.cloth, 3);
		RegisterPartsBasedOnBlock(36, Block.cloth, 4);
		RegisterPartsBasedOnBlock(37, Block.cloth, 5);
		RegisterPartsBasedOnBlock(38, Block.cloth, 6);
		RegisterPartsBasedOnBlock(39, Block.cloth, 7);
		RegisterPartsBasedOnBlock(40, Block.cloth, 8);
		RegisterPartsBasedOnBlock(41, Block.cloth, 9);
		RegisterPartsBasedOnBlock(42, Block.cloth, 10);
		RegisterPartsBasedOnBlock(43, Block.cloth, 11);
		RegisterPartsBasedOnBlock(44, Block.cloth, 12);
		RegisterPartsBasedOnBlock(45, Block.cloth, 13);
		RegisterPartsBasedOnBlock(46, Block.cloth, 14);
		RegisterPartsBasedOnBlock(47, Block.cloth, 15);
		RegisterPartsBasedOnBlock(48, Block.blockGold);
		RegisterPartsBasedOnBlock(49, Block.blockSteel);
		RegisterPartsBasedOnBlock(50, Block.brick);
		RegisterPartsBasedOnBlock(51, Block.tnt);
		RegisterPartsBasedOnBlock(52, Block.bookShelf);
		RegisterPartsBasedOnBlock(53, Block.cobblestoneMossy);
		RegisterPartsBasedOnBlock(54, Block.obsidian);
		RegisterPartsBasedOnBlock(55, Block.mobSpawner);
		RegisterPartsBasedOnBlock(56, Block.oreDiamond);
		RegisterPartsBasedOnBlock(57, Block.blockDiamond);
		RegisterPartsBasedOnBlock(58, Block.workbench);
		RegisterPartsBasedOnBlock(59, Block.stoneOvenIdle);
		RegisterPartsBasedOnBlock(60, Block.oreRedstone);
		RegisterPartsBasedOnBlock(61, Block.blockSnow);
		RegisterPartsBasedOnBlock(62, Block.blockClay);
		RegisterPartsBasedOnBlock(63, Block.jukebox);
		RegisterPartsBasedOnBlock(64, Block.pumpkin);
		RegisterPartsBasedOnBlock(65, Block.netherrack);
		RegisterPartsBasedOnBlock(66, Block.slowSand);
		RegisterPartsBasedOnBlock(67, Block.glowStone);
		RegisterPartsBasedOnBlock(68, Block.pumpkinLantern);
		RegisterPartsBasedOnBlock(69, Block.stoneBrick);
		RegisterPartsBasedOnBlock(70, Block.melon);
		RegisterPartsBasedOnBlock(71, Block.mycelium);
		RegisterPartsBasedOnBlock(72, Block.netherBrick);
		RegisterPartsBasedOnBlock(73, Block.whiteStone, 0);
		RegisterPartsBasedOnBlock(74, Block.whiteStone, 1);
		RegisterPartsBasedOnBlock(75, Block.oreEmerald);
		RegisterPartsBasedOnBlock(76, Block.blockEmerald);
		RegisterPartsBasedOnBlock(77, Block.commandBlock);
		RegisterPartsBasedOnBlock(78, Block.sandStone, 1);
		RegisterPartsBasedOnBlock(79, Block.sandStone, 2);
		RegisterPartsBasedOnBlock(80, Block.redstoneLampIdle);
	}
	
	public static void preinit() {
		// compatibility start
		{
			ConfigCategory category = Config.config.getCategory(Configuration.CATEGORY_ITEM);
			if(category.containsKey("itemSaw.id")) {
				Property prop = category.remove("itemSaw.id");
				Config.config.get(Configuration.CATEGORY_ITEM, "itemSaw", prop.getInt()).value = prop.value;
				Config.save();
			}
		}
		// compatibility end
		
		APILocator.getIDAllocator().requestBlock(ImmibisCore.instance, "blockMultipart", new IIDCallback() {
			@Override
			public void register(int id) {
				blockMultipart = new BlockMicroblockContainer(id, Material.rock);
				blockMultipart.setBlockName("immibis.multipart");
				LanguageRegistry.addName(blockMultipart, "Microblock Container");
				GameRegistry.registerBlock(blockMultipart, ItemMicroblock.class);
			}
		});
		APILocator.getIDAllocator().requestItem(ImmibisCore.instance, "itemSaw", new IIDCallback() {
			@Override
			public void register(int id) {
				itemSaw = new ItemSaw(id - 256);
			}
		});
		APILocator.getIDAllocator().addRecipes(new Runnable() {
			@Override
			public void run() {
				@SuppressWarnings("unchecked")
				List<IRecipe> recipes = CraftingManager.getInstance().getRecipeList();
				
				recipes.add(new RecipeHollowCover());
				recipes.add(new RecipeUnHollowCover());
				recipes.add(new RecipeVerticalCut());
				recipes.add(new RecipeHorizontalCut());
				recipes.add(new RecipeCombineTwo());
				recipes.add(new RecipeCombineSeveral());
				
				GameRegistry.addRecipe(new ItemStack(itemSaw), new Object[] {
					"III",
					"DDI",
					'I', Item.ingotIron,
					'D', Item.diamond
				});
			}
		});
	}
	
	public static void init() {
		APILocator.getNetManager().listen(new IPacketMap() {
			@Override
			public String getChannel() {return CHANNEL;}

			@Override
			public IPacket createS2CPacket(byte id) {
				if(id == PKT_S2C_MICROBLOCK_CONTAINER_DESCRIPTION)
					return new PacketMicroblockContainerDescription();
				return null;
			}
			
			@Override
			public IPacket createC2SPacket(byte id) {
				return null;
			}
		});
		
		SidedProxy.instance.createSidedObject("immibis.core.microblock.ClientProxy", null);
	}
	
	private static void RegisterPartsBasedOnBlock(int n, Block block) {
		RegisterPartsBasedOnBlock(n, block, 0);
	}
	
	private static class Info {
		public EnumPartClass clazz;
		public double size;
		public String prefix, suffix;
		public Info(EnumPartClass c, double s, String pr, String su)
		{
			clazz = c;
			size = s;
			prefix = pr;
			suffix = su;
		}
	}
	
	private static Info blockparts[] = new Info[] {
		new Info(EnumPartClass.Panel, 1.0/8.0, "", " Cover"),
		new Info(EnumPartClass.Panel, 2.0/8.0, "", " Panel"),
		new Info(EnumPartClass.Panel, 3.0/8.0, "", " Triple Cover"),
		new Info(EnumPartClass.Panel, 4.0/8.0, "", " Slab"),
		new Info(EnumPartClass.Panel, 5.0/8.0, "", " Cover Slab"),
		new Info(EnumPartClass.Panel, 6.0/8.0, "", " Triple Panel"),
		new Info(EnumPartClass.Panel, 7.0/8.0, "", " Anticover"),
		null,
		new Info(EnumPartClass.Strip, 1.0/8.0, "", " Cover Strip"),
		new Info(EnumPartClass.Strip, 2.0/8.0, "", " Panel Strip"),
		new Info(EnumPartClass.Strip, 3.0/8.0, "", " Triple Cover Strip"),
		new Info(EnumPartClass.Strip, 4.0/8.0, "", " Slab Strip"),
		new Info(EnumPartClass.Strip, 5.0/8.0, "", " Cover Slab Strip"),
		new Info(EnumPartClass.Strip, 6.0/8.0, "", " Triple Panel Strip"),
		new Info(EnumPartClass.Strip, 7.0/8.0, "", " Anticover Strip"),
		null,
		new Info(EnumPartClass.Corner, 1.0/8.0, "", " Cover Corner"),
		new Info(EnumPartClass.Corner, 2.0/8.0, "", " Panel Corner"),
		new Info(EnumPartClass.Corner, 3.0/8.0, "", " Triple Cover Corner"),
		new Info(EnumPartClass.Corner, 4.0/8.0, "", " Slab Corner"),
		new Info(EnumPartClass.Corner, 5.0/8.0, "", " Cover Slab Corner"),
		new Info(EnumPartClass.Corner, 6.0/8.0, "", " Triple Panel Corner"),
		new Info(EnumPartClass.Corner, 7.0/8.0, "", " Anticover Corner"),
		null,
		new Info(EnumPartClass.HollowPanel, 1.0/8.0, "Hollow ", " Cover"),
		new Info(EnumPartClass.HollowPanel, 2.0/8.0, "Hollow ", " Panel"),
		new Info(EnumPartClass.HollowPanel, 3.0/8.0, "Hollow ", " Triple Cover"),
		new Info(EnumPartClass.HollowPanel, 4.0/8.0, "Hollow ", " Slab"),
		new Info(EnumPartClass.HollowPanel, 5.0/8.0, "Hollow ", " Cover Slab"),
		new Info(EnumPartClass.HollowPanel, 6.0/8.0, "Hollow ", " Triple Panel"),
		new Info(EnumPartClass.HollowPanel, 7.0/8.0, "Hollow ", " Anticover"),
		null,
	};
	
	private static void RegisterPartsBasedOnBlock(int n, Block block, int meta) {
		assert(blockparts.length == 32);
		
		int partIDBase = n*64;
		
		String name = StringTranslate.getInstance().translateKey(
			Item.itemsList[block.blockID].getItemNameIS(
				new ItemStack(block.blockID, 1, meta)
			)+".name"
		);
		
		float hardness;
		try {
			hardness = block.getBlockHardness(null, 0, 0, 0);
		} catch(Throwable e) {
			e.printStackTrace();
			return;
		}
		
		int[] texindices = new int[6];
		for(int k = 0; k < 6; k++)
			texindices[k] = block.getBlockTextureFromSideAndMetadata(k, meta);
		
		for(int k = 0; k < 7; k++)
		{
			// making hollow covers
			RecipeHollowCover.addMap(partIDBase + k, partIDBase + k + 24);
			// reverting hollow covers
			RecipeUnHollowCover.addMap(partIDBase + k + 24, partIDBase + k);
			
			// cutting panels into strips
			RecipeHorizontalCut.addMap(new BlockMetaPair(blockMultipart.blockID, partIDBase + k), new ItemStack(blockMultipart.blockID, 2, partIDBase + k + 8));
			
			// cutting strips into corners
			RecipeHorizontalCut.addMap(new BlockMetaPair(blockMultipart.blockID, partIDBase + k + 8), new ItemStack(blockMultipart.blockID, 2, partIDBase + k + 16));
			
			// combining corners into strips
			RecipeCombineTwo.addMap(partIDBase + k + 16, partIDBase + k + 8);
			
			// combining strips into panels
			RecipeCombineTwo.addMap(partIDBase + k + 8, partIDBase + k);
		}
		
		// combining multiple panels
		RecipeCombineSeveral.addMap(partIDBase, new ItemStack(block, 1, meta));
		
		// combining multiple hollow panels
		RecipeCombineSeveral.addMap(partIDBase + 24, new ItemStack(block, 1, meta));
		
		// cutting full blocks/slabs/panels
		RecipeVerticalCut.addMap(new BlockMetaPair(block.blockID, meta), new ItemStack(blockMultipart.blockID, 2, partIDBase+3));
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, partIDBase+3), new ItemStack(blockMultipart.blockID, 2, partIDBase+1));
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, partIDBase+1), new ItemStack(blockMultipart.blockID, 2, partIDBase+0));
		
		// cutting hollow slabs/panels
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, partIDBase+27), new ItemStack(blockMultipart.blockID, 2, partIDBase+25));
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, partIDBase+25), new ItemStack(blockMultipart.blockID, 2, partIDBase+24));
		
		for(int k = 0; k < blockparts.length; k++)
			if(blockparts[k] != null)
			{
				PartType type = new PartType(
					blockparts[k].clazz,
					blockparts[k].size,
					blockparts[k].prefix+name+blockparts[k].suffix,
					hardness,
					block,
					meta
				);
				type.textures = texindices;
				RegisterPartType(partIDBase+k, type);
			}
	}
	
	public static void RegisterPartType(int id, PartType type) {
		if(parts.containsKey(id))
			throw new PartIDInUseException(id, parts.get(id), type);
		parts.put(id, type);
		neiDamageValues.add(id);
		if(id >= neiMaxDamage)
			neiMaxDamage = id + 1;
		type.id = id;
		SidedProxy.instance.addLocalization("immibis.core.multipart."+id+".name", type.name);
	}
}
