package immibis.core.microblock;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class ItemCoverableBase extends Item {

	protected ItemCoverableBase(int id_minus_256) {
		super(id_minus_256);
	}
	
	public static boolean mergeIntoMultipartBlock(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, int blockID)
	{
		TileEntity te = world.getBlockTileEntity(i, j, k);
		if(te == null || !(te instanceof TileMultipart))
			return false;
		TileMultipart tm = (TileMultipart)te;
		CoverImpl cover = tm.getCoverImpl();
		if(!world.setBlockWithNotify(i, j, k, blockID))
			return false;
		TileCoverableBase tcb = (TileCoverableBase)world.getBlockTileEntity(i, j, k);
		for(Part p : cover.parts)
			tcb.cover.parts.add(p);
		Block b = Block.blocksList[blockID];
		
        b.onBlockPlacedBy(world, i, j, k, entityplayer);
		return true;
	}

}
