package immibis.core.microblock;

import immibis.core.ImmibisCore;
import immibis.core.api.net.IPacket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.entity.player.EntityPlayer;

public class PacketMicroblockDigStart implements IPacket {
	
	public int x, y, z, subhit;

	public PacketMicroblockDigStart(int x, int y, int z, int subhit) {
		this.x = x;
		this.y = y;
		this.z = z;
		this.subhit = subhit;
	}
	
	public PacketMicroblockDigStart() {
		this(0, 0, 0, 0);
	}

	@Override
	public byte getID() {
		return ImmibisCore.PACKET_TYPE_C2S_MICROBLOCK_DIG_START;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		x = in.readInt();
		y = in.readInt();
		z = in.readInt();
		subhit = in.readInt();
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeInt(x);
		out.writeInt(y);
		out.writeInt(z);
		out.writeInt(subhit);
	}

	@Override
	public void onReceived(EntityPlayer source) {
		if(source != null)
			BlockMicroblockContainer.setBreakingSubhit(source, x, y, z, subhit);
	}
	
	@Override
	public String getChannel() {
		return ImmibisCore.CHANNEL;
	}

}
