package immibis.core.microblock.recipes;

import immibis.core.microblock.CoverSystemProxy;

import java.util.HashMap;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeUnHollowCover implements IRecipe {
	
	private static HashMap<Integer, Integer> damageMap = new HashMap<Integer, Integer>();
	
	public static void addMap(int a, int b)
	{
		damageMap.put(a, b);
	}

	@Override
	public boolean matches(InventoryCrafting inventorycrafting, World world) {
		return getCraftingResult(inventorycrafting) != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
		int slot = -1;
		for(int k = 0; k < inventorycrafting.getSizeInventory(); k++)
		{
			ItemStack is = inventorycrafting.getStackInSlot(k);
			if(is == null || is.itemID != CoverSystemProxy.blockMultipart.blockID)
				continue;
			if(slot != -1)
				return null;
			slot = k;
		}
		if(slot == -1)
			return null;
		ItemStack is = inventorycrafting.getStackInSlot(slot);
		Integer o = damageMap.get(is.getItemDamage());
		if(o == null)
			return null;
		return new ItemStack(is.itemID, 1, o.intValue());
	}

	@Override
	public int getRecipeSize() {
		return 1;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return new ItemStack(CoverSystemProxy.blockMultipart, 1, 0);
	}

}
