/*
 * Decompiled with CFR 0.152.
 */
package immibis.core;

import immibis.core.MCVersionProxy;

public class BlockMetaPair {
    public int id;
    public int data;

    public BlockMetaPair(int blockID, int k) {
        this.id = blockID;
        this.data = k;
        if (this.id >= MCVersionProxy.GetBlockIDCount()) {
            this.id = 0;
        }
    }

    public int hashCode() {
        return (this.data << 16) + this.id;
    }

    public boolean equals(Object o) {
        try {
            BlockMetaPair bmp = (BlockMetaPair)o;
            return bmp.id == this.id && bmp.data == this.data;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static BlockMetaPair parse(String s) {
        String[] a = s.split(":");
        if (a.length != 2) {
            throw new NumberFormatException("Not a valid block ID/data value: " + s);
        }
        return new BlockMetaPair(Integer.parseInt(a[0]), Integer.parseInt(a[1]));
    }
}

