package immibis.core.covers;

import immibis.core.*;
import immibis.core.api.porting.SidedProxy;
import immibis.core.net.OneTwoFiveNetworking;

import java.util.ArrayList;

import net.minecraft.client.Minecraft;
import net.minecraft.src.*;
import net.minecraft.src.forge.IHighlightHandler;

public class BlockMultipart extends BlockContainer implements ICoverableBlock {
	
	private final int model;
	
	static AxisAlignedBB selectedBoundingBox = AxisAlignedBB.getBoundingBox(0, 0, 0, 1, 1, 1);
	static int[] texindices = new int[] {0, 0, 0, 0, 0, 0};
	
	public boolean getEnableStats() {return false;}
	
	@Override
	public AxisAlignedBB getSelectedBoundingBoxFromPool(World w, int x, int y, int z) {
		if(selectedBoundingBox == null)
			// Shouldn't happen
			selectedBoundingBox = AxisAlignedBB.getBoundingBox(0, 0, 0, 1, 1, 1);
		return selectedBoundingBox.getOffsetBoundingBox(x, y, z);
	}
	
	@SuppressWarnings("rawtypes")
	@Override
	public void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB mask, ArrayList list) {
		try {
			((ICoverableTile)world.getBlockTileEntity(x, y, z)).getCoverImpl().getCollidingBoundingBoxes(world, x, y, z, mask, list);
		} catch(ClassCastException e) {
			world.setBlockWithNotify(x, y, z, 0);
		}
	}
	
	@Override
	public int getBlockTextureFromSideAndMetadata(int i, int j) {
		return texindices[i];
	}
	
	@Override
	public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
		return texindices[l];
	}
	
	public float blockStrengthMultipart(EntityPlayer ply, int meta) {
		return super.blockStrength(ply, meta);
	}
	
	public void harvestBlockMultipart(World world, EntityPlayer ply, int x, int y, int z, int blockMetadata) {
		super.harvestBlock(world, ply, x, y, z, blockMetadata);
	}
	
	private static float hardness;
	//private static boolean forceHarvestState, forcedHarvestState;
	
	public boolean canHarvestBlockMultipart(EntityPlayer ply, int meta) {
		return true;
		//return super.canHarvestBlock(ply, meta);
	}
	
	@Override
	public final boolean canHarvestBlock(EntityPlayer ply, int meta) {
		//if(forceHarvestState)
			//return forcedHarvestState;
		return canHarvestBlockMultipart(ply, meta);
	}
	
	@Override
	public final float getHardness(int meta) {
		return hardness;
	}
	
	@Override
	public boolean removeBlockByPlayer(World w, EntityPlayer ply, int i, int j, int k) {
		MovingObjectPosition ray = ply.rayTrace(SidedProxy.instance.getPlayerReach(ply), 0);
		if(ray == null || ray.typeOfHit != EnumMovingObjectType.TILE || ray.blockX != i || ray.blockY != j || ray.blockZ != k)
			return false;
		if(ply.capabilities.isCreativeMode) {
			punching_subhit = ray.subHit;
			if(w.isRemote)
				sendDigStart(i, j, k);
			else
				harvestBlock(w, ply, i, j, k, w.getBlockMetadata(i, j, k));
		}
		return ray.subHit == punching_subhit;
	}
	
	@Override
	public void onBlockClicked(World w, int i, int j, int k, EntityPlayer ply) {
		MovingObjectPosition ray = ply.rayTrace(SidedProxy.instance.getPlayerReach(ply), 0);
		if(ray == null || ray.typeOfHit != EnumMovingObjectType.TILE || ray.blockX != i || ray.blockY != j || ray.blockZ != k)
		{
			punching_subhit = -1000;
			return;
		}
		punching_subhit = ray.subHit;
		if(w.isRemote)
			sendDigStart(i, j, k);
	}
	
	private void sendDigStart(int x, int y, int z) {
		OneTwoFiveNetworking.send(mod_ImmibisCore.CHANNEL, new PacketMicroblockDigStart(x, y, z, punching_subhit), null);
	}
	
	
	static int punching_subhit = -1000;
	
	@Override
	public final float blockStrength(EntityPlayer ply, int meta) {
		MovingObjectPosition ray = ply.rayTrace(SidedProxy.instance.getPlayerReach(ply), 0);
		if(ray == null || ray.typeOfHit != EnumMovingObjectType.TILE)
			return 0.01f;
		else
		{
			World world = ply.worldObj;
			int x = ray.blockX;
			int y = ray.blockY;
			int z = ray.blockZ;
			
			if(punching_subhit != ray.subHit)
			{
				punching_subhit = ray.subHit;
				if(ply.worldObj.isRemote)
					sendDigStart(x, y, z);
				
				// Need to reset the block damage, but that doesn't seem to be possible
				// Even RP2's covers don't do that
				/*PlayerController pc = ModLoader.getMinecraftInstance().playerController;
				pc.resetBlockRemoving();
				pc.updateController();*/
			}
			
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te == null || !(te instanceof ICoverableTile))
				return 0.01f;
			else
			{
				CoverImpl cover = ((ICoverableTile)te).getCoverImpl();
				
				if(ray.subHit == -2)
					return blockStrengthMultipart(ply, meta);			
				Part p = cover.parts.get(ray.subHit);
				if(p == null)
					return 0.01f;
				else
				{
					hardness = p.type.hardness;
					if(hardness < 0)
						return 0;
					if(!p.type.canHarvestCover(ply))
						return 0.01F / hardness;
					return ply.getCurrentPlayerStrVsBlock(p.type.modelBlock, meta) / hardness / 30F;
				}
			}
		}
	}

	@Override
	public final void harvestBlock(World world, EntityPlayer ply, int x, int y, int z, int meta) {
		if(world.isRemote)
			return;
		MovingObjectPosition ray = ply.rayTrace(SidedProxy.instance.getPlayerReach(ply), 0);
		if(ray == null || ray.typeOfHit != EnumMovingObjectType.TILE || ray.blockX != x || ray.blockY != y || ray.blockZ != z || ray.subHit != punching_subhit) {
			return;
		}
		try {
			((ICoverableTile)world.getBlockTileEntity(x, y, z)).getCoverImpl().harvestBlock(world, ply, x, y, z, ray.subHit);
		} catch(ClassCastException e) {
			world.setBlockWithNotify(x, y, z, 0);
		}
	}
	
	@Override
	public void dropBlockAsItem_do(World w, int x, int y, int z, ItemStack is) {
		super.dropBlockAsItem_do(w, x, y, z, is);
	}
	
	void setAABB(AxisAlignedBB aabb)
	{
		minX = aabb.minX;
		minY = aabb.minY;
		minZ = aabb.minZ;
		maxX = aabb.maxX;
		maxY = aabb.maxY;
		maxZ = aabb.maxZ;
	}

	protected BlockMultipart(int id, Material mat, int model) {
		super(id, mat);
		this.model = model;
	}
	
	MovingObjectPosition defaultCollisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
		return super.collisionRayTrace(world, x, y, z, src, dst);
	}
	
	@Override
	public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
		try {
			return ((ICoverableTile)world.getBlockTileEntity(x, y, z)).getCoverImpl().collisionRayTrace(world, x, y, z, src, dst);
		} catch(ClassCastException e) {
			world.setBlockWithNotify(x, y, z, 0);
			return super.collisionRayTrace(world, x, y, z, src, dst);
		}
	}
	
	@Override
	public final boolean isOpaqueCube() {
		return false;
	}
	
	@Override
	public final boolean renderAsNormalBlock() {
		return false;
	}
	
	@Override
	public int getRenderType() {
		return model;
	}

	@Override
	public TileEntity getBlockEntity() {
		return new TileMultipart();
	}

	// this does something on the server
	public static void setPunchingSubhit(EntityPlayer source, int subhit) {
	}

}
