package immibis.core.covers.recipes;

import immibis.core.BlockMetaPair;
import immibis.core.covers.CoverSystemProxy;

import java.util.HashMap;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.ItemStack;

public class RecipeHorizontalCut implements IRecipe {

	private static HashMap<BlockMetaPair, ItemStack> damageMap = new HashMap<BlockMetaPair, ItemStack>();
	
	public static void addMap(BlockMetaPair a, ItemStack b)
	{
		damageMap.put(a, b);
	}

	@Override
	public boolean matches(InventoryCrafting inventorycrafting) {
		return getCraftingResult(inventorycrafting) != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
		ItemStack is;
        for (int i = 0; i <= 1; i++)
            for (int j = 0; j <= 2; j++)
            {
            	is = check(inventorycrafting, i, j, true);
                if(is != null) return is;
            	is = check(inventorycrafting, i, j, false);
                if(is != null) return is;                
            }
        return null;
	}
	
	private ItemStack check(InventoryCrafting i, int xo, int yo, boolean flip) {
		ItemStack saw = i.getStackInRowAndColumn(xo + (flip ? 1 : 0), yo);
		if(saw == null || saw.itemID != CoverSystemProxy.itemSaw.shiftedIndex)
			return null;
		ItemStack block = i.getStackInRowAndColumn(xo + (flip ? 0 : 1), yo);
		if(block == null)
			return null;
		return ItemStack.copyItemStack(damageMap.get(new BlockMetaPair(block.itemID, block.getItemDamage())));
	}

	@Override
	public int getRecipeSize() {
		return 2;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return new ItemStack(CoverSystemProxy.blockMultipart, 1, 0);
	}
}
