package immibis.core;

import java.util.ArrayList;
import java.util.List;

import immibis.core.api.porting.PortableTileEntity;
import immibis.core.net.IPacket;
import immibis.core.net.OneTwoFiveNetworking;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Packet;
import net.minecraft.src.TileEntity;

public abstract class TileCombined extends PortableTileEntity {
	
	public boolean redstone_output = false;
	
	public List<ItemStack> getInventoryDrops() {
		return new ArrayList<ItemStack>();
	}

	public void onBlockNeighbourChange() {}
	public boolean onBlockActivated(EntityPlayer player) {return false;}
	public void onBlockRemoval() {}
	
	public void notifyNeighbouringBlocks() {
		worldObj.notifyBlocksOfNeighborChange(xCoord, yCoord, zCoord, worldObj.getBlockId(xCoord, yCoord, zCoord));
	}
	
	public void resendDescriptionPacket() {
		worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
	}
	
	public Packet getDescriptionPacket() {
		IPacket p = getDescriptionPacket2();
		if(p == null)
			return null;
		return OneTwoFiveNetworking.wrap(p, getDescriptionChannel());
	}
	
	public String getDescriptionChannel() {
		return null;
	}
	
	public IPacket getDescriptionPacket2() {
		return null;
	}
	
	// look = The closest axis to the direction the player is looking towards
	public void onPlaced(EntityLiving player, int look) {}
}
