package immibis.core.api.porting;

import java.io.File;

import net.minecraft.src.*;

public abstract class SidedProxy {
	public static SidedProxy instance;
	
	static {
	/* $if mc == 1.2.5$ */
		/* $if jclient$ */
		instance = new immibis.core.porting.ClientProxy125();
		/* $else$ */
		instance = new immibis.core.porting.ServerProxy125();
		/* $endif$ */
	/* $endif$ */
	}
	
	public abstract File getMinecraftDir();
	public abstract void addLocalization(String key, String value);
	public abstract void sendChat(String msg, EntityPlayer player);
	public abstract double getPlayerReach(EntityPlayer ply);
	public abstract EntityPlayer getThePlayer();
	public abstract int getUniqueBlockModelID(String renderClass, boolean b);
	public abstract boolean isOp(String player);
	public abstract void preloadTexture(String texfile);
	public abstract void registerTileEntity(Class<? extends TileEntity> clazz, String id, String rclass);
	public abstract boolean isWorldCurrent(World w);
	public abstract void registerItemRenderer(int itemID, String renderClassName);
	public abstract void registerServerPacketHandler(String channel, IServerPacketHandler handler);
	public abstract void registerClientPacketHandler(String channel, IClientPacketHandler handler);
	public abstract void sendPacket(Packet250CustomPayload wrap, EntityPlayer player);
	public abstract void setGuiHandler(PortableBaseMod mod, PortableGuiHandler handler);
	/* $if mc < 1.3$
	public abstract Vec3D createVector(IBlockAccess world, double x, double y, double z);
	$else$ */
	public abstract Vec3 createVector(IBlockAccess world, double x, double y, double z);
	/* $endif$ */
	
	// Note: isClient and isServer may both be true for the same entity (in non-joined SSP)
	public abstract boolean isClient(Entity e);
	public abstract boolean isServer(Entity e);
	
	public abstract boolean isDedicatedServer();
}
