package immibis.core.covers;

import net.minecraft.src.Block;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public abstract class TileCoverableBase extends TileEntity implements ICoverableTile {
	
	protected CoverImpl cover;
	private Part fakeCentrePart;
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		cover.writeToNBT(tag);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		cover.readFromNBT(tag);
	}
	
	public TileCoverableBase(BlockCoverableBase wrappedBlock, double hollow_edge_size) {
		cover = new CoverImpl(this, hollow_edge_size);
		fakeCentrePart = new Part(new PartType(EnumPartClass.Centre, 0.5, "Fake centre part for wrapped block", -1, Block.redstoneWire, 0), EnumPosition.Centre);
		cover.wrappedBlock = wrappedBlock;
	}
	
	public boolean isSideOpen(int side) {
		return cover.isSideOpen(side);
	}

	@Override
	public CoverImpl getCoverImpl() {
		return cover;
	}

	public boolean isSideOpen(int l, int i1, int j1) {
		return cover.isSideOpen(xCoord, yCoord, zCoord, l, i1, j1);
	}

	public Part getFakeCentrePart() {
		return fakeCentrePart;
	}

	public void convertToMultipartBlockInPlace() {
		if(cover.parts.size() == 0)
			worldObj.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
		else
		{
			worldObj.setBlockWithNotify(xCoord, yCoord, zCoord, CoverSystemProxy.blockMultipart.blockID);
			CoverImpl c2 = ((ICoverableTile)worldObj.getBlockTileEntity(xCoord, yCoord, zCoord)).getCoverImpl();
			for(Part p : cover.parts)
				c2.parts.add(p);
		}
	}

}
