package immibis.core.net;

import immibis.core.api.porting.IClientPacketHandler;
import immibis.core.api.porting.IServerPacketHandler;
import immibis.core.api.porting.SidedProxy;

import java.io.*;
import java.util.logging.Level;
import java.util.*;

/* $if mc > 1.3$ */
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;
/* $endif$ */

import net.minecraft.src.*;
import net.minecraft.src.forge.*;

public class OneTwoFiveNetworking {

	public static Packet250CustomPayload wrap(IPacket packet, String channel) {
		Packet250CustomPayload p = new Packet250CustomPayload();
		p.channel = channel;
		ByteArrayOutputStream bytes = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(bytes);
		try {
			out.writeByte(packet.getID());
			packet.write(out);
			
			p.data = bytes.toByteArray();
			p.length = p.data.length;
			
			return p;
			
		} catch(IOException e) {
			ModLoader.getLogger().log(Level.SEVERE, "While trying to send packet of type "+packet.getClass().getName(), e);
			return null;
		} finally {
			try {
				out.close();
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	// Sends a packet to a player on a channel.
	// If player is null, packet is sent to the server.
	
	/* $if !joined$
	public static void send(String channel, IPacket packet, EntityPlayer player) {
	
		$if client2$
		if(!ModLoader.getMinecraftInstance().theWorld.isRemote) {
			// this looks broken (argument should be thePlayer if player==null)
			// but it works
			// can't change it now, it would probably break something
			packet.onReceived(null);
			return;
		}
		$endif$
		
		sendRealPacket(wrap(packet, channel), player);
	}
	
	private static void sendRealPacket(Packet250CustomPayload packet, EntityPlayer player) {
		if(packet == null)
			return;
		
		$if client2$
		net.minecraft.client.Minecraft mc = ModLoader.getMinecraftInstance();
		if(player == null)
			mc.getSendQueue().addToSendQueue(packet);
		else if(player == mc.thePlayer)
			onReceivePacket(packet, player);
		else
			throw new IllegalArgumentException("Clients can only send packets to the server or to themselves (tried to send from "+mc.thePlayer.username+" to "+player.username+")");
		
		$else$
		if(player instanceof EntityPlayerMP)
			((EntityPlayerMP)player).playerNetServerHandler.netManager.addToSendQueue(packet);
		
		$endif$
	}
	
	private static void onReceivePacket(Packet250CustomPayload p, EntityPlayer source) {
		onReceivePacket(p.channel, p.data, source, clientChannels.get(p.channel));
	}
	$else$ */
	public static void send(String channel, IPacket packet, EntityPlayer player) {
		SidedProxy.instance.sendPacket(wrap(packet, channel), player);
	}
	/* $endif$ */
	
	private static void onReceivePacket(String channel, byte[] data, EntityPlayer source, IPacketMap mod) {
		
		DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
		
		try {
			byte id = in.readByte();
			IPacket packet = mod.createPacket(id);
			if(packet == null)
				return;
			packet.read(in);
			packet.onReceived(source);
		} catch(IOException e) {
			ModLoader.getLogger().log(Level.SEVERE, "While trying to receive packet on channel " + channel, e);
		} finally {
			try {
				in.close();
			} catch(Exception e) {e.printStackTrace();}
		}
	}
	
	private static Map<String, IPacketMap> clientChannels = new HashMap<String, IPacketMap>();
	
	/* $if jclient$ */
	public static void initReceiveClient(final IPacketMap mod, final String channel) {
		clientChannels.put(channel, mod);
		SidedProxy.instance.registerClientPacketHandler(channel, new IClientPacketHandler() {
			@Override
			public void onPacketData(String channel_, byte[] data) {
				onReceivePacket(channel, data, null, mod);
			}
		});
	}
	/* $else$
	public static void initReceiveClient(final IPacketMap mod, final String channel) {}
	$endif$ */
	
	/* $if jserver$ */
	public static void initReceiveServer(final IPacketMap mod, final String channel) {
		SidedProxy.instance.registerServerPacketHandler(channel, new IServerPacketHandler() {
			@Override
			public void onPacketData(String channel_, byte[] data, EntityPlayer source) {
				onReceivePacket(channel, data, source, mod);
			}
		});
	}
	/* $else$
	public static void initReceiveServer(final IPacketMap mod, final String channel) {}
	$endif$ */
	
	
}
