package immibis.core;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import immibis.core.api.porting.PortableContainer;
import immibis.core.net.AbstractSyncedContainer;

public class FakeSlotContainer extends AbstractSyncedContainer {
	
	public FakeSlotContainer(EntityPlayer player, IInventory inv) {
		super(player, inv);
	}

	@Override
	/* $if mc < 1.4$
	public ItemStack slotClick(int slot, int button, boolean shift, EntityPlayer player)
	$else$ */
	public ItemStack slotClick(int slot, int button, int shift, EntityPlayer player)
	/* $endif$ */
    {
        if(slot >= 0 && inventorySlots.get(slot) instanceof SlotFake) {
        	SlotFake fs = (SlotFake)inventorySlots.get(slot);
        	ItemStack heldStack = player.inventory.getItemStack();
        	/* $if mc < 1.4$
        	fs.onClickByItem(heldStack, button, shift);
        	$else$ */
        	fs.onClickByItem(heldStack, button, shift == 1);
        	/* $endif$ */
        	return null;
        }
        return super.slotClick(slot, button, shift, player);
    }

	@Override
	public String getChannel() {
		return null;
	}
}
