package immibis.core.api;

import java.util.HashMap;
import java.util.Map;

import immibis.core.Config;

public class IDAllocator {
	private static HashMap<String, IBlockIDCallback> block_id_callbacks = new HashMap<String, IBlockIDCallback>();
	
	public static void RegisterBlockID(String name, IBlockIDCallback cb) {
		int id = Config.getBlockID(name, false);
		if(id != 0)
			cb.registerBlock(id);
		else
			block_id_callbacks.put(name, cb);
	}
	
	public static void AllocateBlockIDs() {
		Config.save();
		for(Map.Entry<String, IBlockIDCallback> e : block_id_callbacks.entrySet())
		{
			e.getValue().registerBlock(Config.getBlockID(e.getKey(), true));
		}
		block_id_callbacks.clear();
		Config.save();
	}
}
