package immibis.microblocks;

import immibis.core.ImmibisCore;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import cpw.mods.fml.common.Loader;

public class NEIMicroblocksConfig implements IConfigureNEI {
	@Override
	public void loadConfig() {
		if(MicroblockSystem.INSTANCE != null) {
			try {
				API.setMaxDamageException(MicroblockSystem.microblockContainerBlock.blockID, 1);
				for(int i : MicroblockSystem.neiPartIDs)
					API.addNBTItem(ItemMicroblock.getStackWithPartID(i));
				API.addSetRange("Blocks.Microblocks", new MultiItemRange().add(MicroblockSystem.microblockContainerBlock));
			} catch(Throwable e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public String getName() {
		return "Immibis Core";
	}

	@Override
	public String getVersion() {
		return Loader.instance().getReversedModObjectList().get(ImmibisCore.instance).getVersion();
	}
}
