package immibis.microblocks.coremod;

import immibis.core.ImmibisCore;
import immibis.microblocks.JavaYUMakeMeHaveThisClass;
import immibis.microblocks.MicroblockSystem;
import immibis.microblocks.ModProperties;

import java.util.Arrays;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;

import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;

public class MicroblocksModContainer extends DummyModContainer {

	public MicroblocksModContainer() {
		super(new ModMetadata());
		ModMetadata md = getMetadata();
		
		md.modId = "ImmibisMicroblocks";
		md.name = "Immibis's Microblocks";
		md.version = ModProperties.MOD_VERSION;
		md.credits = "";
		md.authorList = Arrays.asList("immibis");
		md.description = "";
		md.url = "http://www.minecraftforum.net/topic/1001131-110-immibiss-mods-smp/";
		md.updateUrl = "";
		md.screenshots = new String[0];
		md.logoFile = "";
	}
	
	@Override
	public VersionRange acceptableMinecraftVersionRange() {
		// update all transformers' obf names when updating
		return VersionParser.parseRange("[1.4.6,1.4.7]");
	}
	
	@Override
	public boolean registerBus(EventBus bus, LoadController controller) {
		bus.register(this);
		return true;
	}
	
	@Subscribe
	public void construct(FMLConstructionEvent evt) {
		/*ImmibisCore.isCoreModActive = true;
		ImmibisCore.instance = new ImmibisCore();
		try {
			if(FMLRelauncher.side().equals("CLIENT")) {
				ImmibisCore.sidedProxy = (SidedProxy)Class.forName("immibis.core.porting.ClientProxy142").newInstance();
			} else {
				ImmibisCore.sidedProxy = (SidedProxy)Class.forName("immibis.core.porting.ServerProxy142").newInstance();
			}
		} catch(Exception e) {
			throw new RuntimeException(e);
		}*/
	}
	
	@Subscribe
	public void preinit(FMLPreInitializationEvent evt) {
		JavaYUMakeMeHaveThisClass.preinit(evt);
	}
	
	@Subscribe
	public void init(FMLInitializationEvent evt) {
		JavaYUMakeMeHaveThisClass.init(evt);
	}
	
	@Subscribe
	public void postinit(FMLPostInitializationEvent evt) {
		JavaYUMakeMeHaveThisClass.postinit(evt);
	}
}
