package immibis.ccperiphs;

import java.util.ArrayList;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import immibis.ccperiphs.rfid.TileRFIDWriter;
import immibis.core.BlockCombined;
import immibis.core.api.Dir;

public class BlockPeriphs extends BlockCombined {
	
	public static int model;

	public BlockPeriphs(int i) {
		super(i, Material.iron, "/immibis/ccperiphs/world.png");
	}
	
	@Override
	public void setBlockBoundsBasedOnState(IBlockAccess w, int x, int y, int z) {
		EnumPeriphs type = EnumPeriphs.values()[w.getBlockMetadata(x, y, z)];
		TileEntity te = w.getBlockTileEntity(x, y, z);
		
		switch(type) {
		case RFID_WRITER:
			if(te == null) return;
			
			switch(((TileRFIDWriter)te).facing) {
			case Dir.PY: setBlockBounds(0, 0, 0, 1, 9/16.0f, 1); break;
			case Dir.PX: setBlockBounds(0, 0, 0, 9/16.0f, 1, 1); break;
			case Dir.NX: setBlockBounds(7/16.0f, 0, 0, 1, 1, 1); break;
			case Dir.PZ: setBlockBounds(0, 0, 0, 1, 1, 9/16.0f); break;
			case Dir.NZ: setBlockBounds(0, 0, 7/16.0f, 1, 1, 1); break;
			}
			break;
		default:
			setBlockBounds(0, 0, 0, 1, 1, 1);
			break;
		}
	}

	// @Override // client only override
	public int getBlockTextureFromSideAndMetadata(int side, int data) {return 0;}
	
	// @Override // client only override
	/*public int getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		TilePeriphs t;
		try {
			t = (TilePeriphs)w.getBlockTileEntity(x, y, z);
		} catch(Exception e) {
			return 0;
		}
		
		if(t == null)
			return 0;
		
		return t.getTexture(side);
	}*/
	
	@Override
	public boolean isOpaqueCube() {
        return false;
    }
	
	@Override
	public boolean renderAsNormalBlock() {
		return false;
	}
	
	@Override
	public boolean isBlockSolid(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
		return false;
	}
	
	@Override
	public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
		setBlockBoundsBasedOnState(par1World, par2, par3, par4);
		return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
	}
	
	/* $if jclient$ */
		@Override
		public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
			setBlockBoundsBasedOnState(par1World, par2, par3, par4);
			return super.getSelectedBoundingBoxFromPool(par1World, par2, par3, par4);
		}
	/* $endif$ */
	
	@Override
	public int getRenderType() {
		return model;
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		return EnumPeriphs.values()[data].createTile();
	}

	@Override
	public void addCreativeItems(ArrayList arraylist) {
		for(EnumPeriphs e : EnumPeriphs.values())
			arraylist.add(new ItemStack(this, 1, e.ordinal()));
	}
}
