package immibis.ccperiphs;

import immibis.ccperiphs.rfid.TileMagStripe;
import immibis.ccperiphs.rfid.TileRFIDReader;
import immibis.ccperiphs.rfid.TileRFIDWriter;
//import immibis.ccperiphs.smartcard.TileSCInterface;

import java.lang.reflect.InvocationTargetException;

public enum EnumPeriphs {
	RFID_WRITER("RFID writer", TileRFIDWriter.class),
	RFID_READER("RFID reader", TileRFIDReader.class),
	MAG_STRIPE("Mag-card reader", TileMagStripe.class),
	//SC_WRITER("Smartcard reader", TileSCInterface.class),
	;
	
	private EnumPeriphs(String name, Class<? extends TilePeriphs> teclass) {
		this.name = name;
		this.teclass = teclass;
	}
	
	public final String name;
	public final Class<? extends TilePeriphs> teclass;
	
	public TilePeriphs createTile() {
		try {
			return teclass.getConstructor().newInstance();
		} catch (InstantiationException e) {
			throw new RuntimeException(e);
		} catch (InvocationTargetException e) {
			throw new RuntimeException(e);
		} catch (NoSuchMethodException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}
}
