package immibis.ccperiphs;

/* $if jclient$ */

import java.util.Random;

import org.lwjgl.opengl.GL11;

import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.rfid.ItemCardBase;
import immibis.ccperiphs.rfid.TileMagStripe;
import immibis.ccperiphs.rfid.TileRFIDWriter;
import immibis.core.api.Dir;
import immibis.core.aspects.ClientOnly;
import net.minecraft.src.ModLoader;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.Tessellator;
import net.minecraft.src.forge.*;
import net.minecraftforge.client.*;


@ClientOnly
public class RenderUtils {
	private static float u, v;
	private static RenderBlocks render;
	private static Random random = new Random();
	private static void setTexture(int i) {
		if(render.overrideBlockTexture >= 0)
			i = render.overrideBlockTexture;
		u = (i % 16) / 16.0f;
		v = (i / 16) / 16.0f;
	}
	
	public static void renderBlockStatic(RenderBlocks render, int meta, TilePeriphs t, double x, double y, double z) {
		EnumPeriphs type = EnumPeriphs.values()[meta];
		
		RenderUtils.render = render;
		
		if(t != null) {
			// rendering block, not item
			immibis.core.RenderUtils.setBrightness(render.blockAccess, (int)x, (int)y, (int)z);
			Tessellator.instance.setColorOpaque(255, 255, 255);
		}
		
		switch(type) {
		case RFID_WRITER:
			renderRFIDWriterStatic(x, y, z, t == null ? Dir.PY : ((TileRFIDWriter)t).facing);
			break;
		case RFID_READER:
			renderRFIDReaderStatic(x, y, z);
			break;
		case MAG_STRIPE:
			renderMagStripeStatic(x, y, z, t == null ? Dir.PY : ((TileMagStripe)t).facing, t == null ? TileMagStripe.STATE_OFF : ((TileMagStripe)t).state);
		}
	}

	public static void renderInvBlock(RenderBlocks render, int meta) {
		EnumPeriphs type = EnumPeriphs.values()[meta];
		
		RenderUtils.render = render;
		
		GL11.glPushMatrix();
		GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
		
		/* $if mc < 1.3$
		MinecraftForgeClient.bindTexture("/immibis/ccperiphs/world.png");
		$else$ */
		ForgeHooksClient.bindTexture("/immibis/ccperiphs/world.png", 0);
		/* $endif$ */
		switch(type) {
		case RFID_WRITER:
			renderRFIDWriterDynamic(Dir.PY, 1, 0, false, false, -1);
			break;
		}
		/* $if mc < 1.3$
		MinecraftForgeClient.unbindTexture();
		$else$ */
		ForgeHooksClient.unbindTexture();
		/* $endif$ */
		
		GL11.glPopMatrix();
	}

	public static void renderRFIDWriterDynamic(int facing, float closed, int progress, boolean on, boolean running, int cardColour) {
		// rotate the modelview matrix so +Y is the direction it's facing
		switch(facing) {
		case Dir.PY:
			break;
		case Dir.PZ:
			GL11.glRotatef(90, 1, 0, 0);
			GL11.glTranslatef(0, 0, -1);
			break;
		case Dir.NZ:
			GL11.glRotatef(-90, 1, 0, 0);
			GL11.glTranslatef(1, -1, 1);
			GL11.glRotatef(180, 0, 1, 0);
			break;
		case Dir.NX:
			GL11.glRotatef(90, 0, 0, 1);
			GL11.glTranslatef(1, -1, 0);
			GL11.glRotatef(-90, 0, 1, 0);
			break;
		case Dir.PX:
			GL11.glRotatef(-90, 0, 0, 1);
			GL11.glTranslatef(-1, 0, 1);
			GL11.glRotatef(90, 0, 1, 0);
			break;
		}
		
		int runTex = (!on ? 9 : (
			running
			? random.nextInt(12) + 16
			: random.nextInt(2) + 10
		));
		
		int progTex = 32 + progress;
		
		//closed = 0.5f + 0.5f*(float)Math.cos(ModLoader.getMinecraftInstance().theWorld.getWorldTime() / 20.0);
		
		GL11.glTranslatef(0, 9/16.0f, 0);
		GL11.glScalef(1/16.0f, 1/16.0f, 1/16.0f);
		
		Tessellator t = Tessellator.instance;
		
		// depth func is already LEQUAL
		//GL11.glDepthFunc(GL11.GL_LEQUAL);
		
		
		t.startDrawingQuads();
		
		setTexture(facing == Dir.PY ? 4 : 3);
		t.addVertexWithUV(0, 0, 0, u, v);
		t.addVertexWithUV(0, 0, 16, u, v+1/16.0f);
		t.addVertexWithUV(16, 0, 16, u+1/16.0f, v+1/16.0f);
		t.addVertexWithUV(16, 0, 0, u+1/16.0f, v);
		
		if(runTex >= 0) {
			setTexture(runTex);
			t.addVertexWithUV(0, 0, 0, u, v);
			t.addVertexWithUV(0, 0, 16, u, v+1/16.0f);
			t.addVertexWithUV(16, 0, 16, u+1/16.0f, v+1/16.0f);
			t.addVertexWithUV(16, 0, 0, u+1/16.0f, v);
		}
		
		if(progTex >= 0) {
			setTexture(progTex);
			t.addVertexWithUV(0, 0, 0, u, v);
			t.addVertexWithUV(0, 0, 16, u, v+1/16.0f);
			t.addVertexWithUV(16, 0, 16, u+1/16.0f, v+1/16.0f);
			t.addVertexWithUV(16, 0, 0, u+1/16.0f, v);
		}
		
		if(cardColour >= 0) {
			setTexture(48 + cardColour);
			// 9, 6, 13, 11
			t.addVertexWithUV(9, 0.01, 6, u+1/16.0f, v+3/256.0f);
			t.addVertexWithUV(9, 0.01, 11, u, v+3/256.0f);
			t.addVertexWithUV(13, 0.01, 11, u, v+13/256.0f);
			t.addVertexWithUV(13, 0.01, 6, u+1/16.0f, v+13/256.0f);
		}
		
		t.draw();
		
		//GL11.glDepthFunc(GL11.GL_LESS);
		
		GL11.glTranslatef(8, 0.01f, 5);
		
		// now 0,0,0 is top left of white square border
		// and coordinates are in pixels
				
		GL11.glRotatef(-90 + 90*closed, 1, 0, 0);
		
		t.startDrawingQuads();
		
		t.setColorRGBA(255, 255, 255, 192);
		GL11.glEnable(GL11.GL_BLEND);
		
		// Z sides
		t.addVertexWithUV(0, 0, 0, 128/256.0, 0/256.0);
		t.addVertexWithUV(6, 0, 0, 134/256.0, 0/256.0);
		t.addVertexWithUV(6, 5, 0, 134/256.0, 5/256.0);
		t.addVertexWithUV(0, 5, 0, 128/256.0, 5/256.0);

		t.addVertexWithUV(0, 0, 7, 128/256.0, 0/256.0);
		t.addVertexWithUV(6, 0, 7, 134/256.0, 0/256.0);
		t.addVertexWithUV(6, 5, 7, 134/256.0, 5/256.0);
		t.addVertexWithUV(0, 5, 7, 128/256.0, 5/256.0);
		
		// X sides
		t.addVertexWithUV(0, 0, 0, 135/256.0, 0/256.0);
		t.addVertexWithUV(0, 0, 7, 135/256.0, 7/256.0);
		t.addVertexWithUV(0, 5, 7, 140/256.0, 7/256.0);
		t.addVertexWithUV(0, 5, 0, 140/256.0, 0/256.0);
		
		t.addVertexWithUV(6, 0, 0, 135/256.0, 0/256.0);
		t.addVertexWithUV(6, 0, 7, 135/256.0, 7/256.0);
		t.addVertexWithUV(6, 5, 7, 140/256.0, 7/256.0);
		t.addVertexWithUV(6, 5, 0, 140/256.0, 0/256.0);
		
		// Top
		t.addVertexWithUV(0, 5, 0, 128/256.0,  6/256.0);
		t.addVertexWithUV(0, 5, 7, 128/256.0, 13/256.0);
		t.addVertexWithUV(6, 5, 7, 134/256.0, 13/256.0);
		t.addVertexWithUV(6, 5, 0, 134/256.0,  6/256.0);
		
		t.draw();
		
		GL11.glDisable(GL11.GL_BLEND);
		
	}

	private static void renderRFIDWriterStatic(double x, double y, double z, byte facing) {
		Tessellator t = Tessellator.instance;
		
		final double duv = 1/16.0f;
		final double thick = 9/16.0f; // thickness of the block
		
		final double duv2 = (duv - thick / 16.0f);
		
		switch(facing) {
		case Dir.PY:
			// bottom
			setTexture(2);
			t.setNormal(0.0F, -1.0F, 0.0F);
	        t.addVertexWithUV(x  , y, z  , u, v);
			t.addVertexWithUV(x+1, y, z  , u+duv, v);
			t.addVertexWithUV(x+1, y, z+1, u+duv, v+duv);
			t.addVertexWithUV(x  , y, z+1, u, v+duv);
			
			// sides
			setTexture(5);
			t.setNormal(0.0F, 0.0F, -1.0F);
			t.addVertexWithUV(x  , y        , z, u+duv, v+duv);
			t.addVertexWithUV(x  , y+thick  , z, u+duv, v+duv2);
			t.addVertexWithUV(x+1, y+thick  , z, u, v+duv2);
			t.addVertexWithUV(x+1, y        , z, u, v+duv);
			
			t.setNormal(0.0F, 0.0F, 1.0F);
	        t.addVertexWithUV(x+1, y+thick  , z+1, u, v+duv2);
			t.addVertexWithUV(x  , y+thick  , z+1, u+duv, v+duv2);
			t.addVertexWithUV(x  , y        , z+1, u+duv, v+duv);
			t.addVertexWithUV(x+1, y        , z+1, u, v+duv);
			
			t.setNormal(-1.0F, 0.0F, 0.0F);
	        t.addVertexWithUV(x, y+thick  , z  , u, v+duv2);
			t.addVertexWithUV(x, y        , z  , u, v+duv);
			t.addVertexWithUV(x, y        , z+1, u+duv, v+duv);
			t.addVertexWithUV(x, y+thick  , z+1, u+duv, v+duv2);
			
			t.setNormal(1.0F, 0.0F, 0.0F);
	        t.addVertexWithUV(x+1, y+thick  , z  , u, v+duv2);
			t.addVertexWithUV(x+1, y+thick  , z+1, u+duv, v+duv2);
			t.addVertexWithUV(x+1, y        , z+1, u+duv, v+duv);
			t.addVertexWithUV(x+1, y        , z  , u, v+duv);
			break;
		
		case Dir.PX:
			// bottom
			setTexture(6);
			t.setNormal(0.0F, -1.0F, 0.0F);
	        t.addVertexWithUV(x      , y, z  , u, v+duv);
			t.addVertexWithUV(x+thick, y, z  , u, v+duv2);
			t.addVertexWithUV(x+thick, y, z+1, u+duv, v+duv2);
			t.addVertexWithUV(x      , y, z+1, u+duv, v+duv);
			
			// Z sides
			setTexture(7);
			t.setNormal(0.0F, 0.0F, -1.0F);
			t.addVertexWithUV(x      , y  , z, u+duv2, v+duv);
			t.addVertexWithUV(x      , y+1, z, u+duv2, v);
			t.addVertexWithUV(x+thick, y+1, z, u+duv, v);
			t.addVertexWithUV(x+thick, y  , z, u+duv, v+duv);
			
			t.setNormal(0.0F, 0.0F, 1.0F);
			t.addVertexWithUV(x+thick, y  , z+1, u+duv, v+duv);
			t.addVertexWithUV(x+thick, y+1, z+1, u+duv, v);
			t.addVertexWithUV(x      , y+1, z+1, u+duv2, v);
			t.addVertexWithUV(x      , y  , z+1, u+duv2, v+duv);
			
			// Back
			setTexture(1);
			t.setNormal(-1.0F, 0.0F, 0.0F);
	        t.addVertexWithUV(x, y+1, z  , u, v);
			t.addVertexWithUV(x, y  , z  , u, v+duv);
			t.addVertexWithUV(x, y  , z+1, u+duv, v+duv);
			t.addVertexWithUV(x, y+1, z+1, u+duv, v);
			
			// top
			setTexture(6);
			t.setNormal(0.0F, 1.0F, 0.0F);
			t.addVertexWithUV(x      , y+1, z+1, u+duv, v+duv);
			t.addVertexWithUV(x+thick, y+1, z+1, u+duv, v+duv2);
			t.addVertexWithUV(x+thick, y+1, z  , u, v+duv2);
			t.addVertexWithUV(x      , y+1, z  , u, v+duv);
			
			break;
		case Dir.NX:
			// bottom
			setTexture(6);
			t.setNormal(0.0F, -1.0F, 0.0F);
	        t.addVertexWithUV(x+1-thick, y, z  , u, v+duv);
			t.addVertexWithUV(x+1      , y, z  , u, v+duv2);
			t.addVertexWithUV(x+1      , y, z+1, u+duv, v+duv2);
			t.addVertexWithUV(x+1-thick, y, z+1, u+duv, v+duv);
			
			// Z sides
			setTexture(7);
			t.setNormal(0.0F, 0.0F, -1.0F);
			t.addVertexWithUV(x+1-thick, y  , z, u+duv2, v+duv);
			t.addVertexWithUV(x+1-thick, y+1, z, u+duv2, v);
			t.addVertexWithUV(x+1      , y+1, z, u+duv, v);
			t.addVertexWithUV(x+1      , y  , z, u+duv, v+duv);
			
			t.setNormal(0.0F, 0.0F, 1.0F);
			t.addVertexWithUV(x+1      , y  , z+1, u+duv, v+duv);
			t.addVertexWithUV(x+1      , y+1, z+1, u+duv, v);
			t.addVertexWithUV(x+1-thick, y+1, z+1, u+duv2, v);
			t.addVertexWithUV(x+1-thick, y  , z+1, u+duv2, v+duv);
			
			// Back
			setTexture(1);
			t.setNormal(1.0F, 0.0F, 0.0F);
			t.addVertexWithUV(x+1, y+1, z+1, u+duv, v);
			t.addVertexWithUV(x+1, y  , z+1, u+duv, v+duv);
			t.addVertexWithUV(x+1, y  , z  , u, v+duv);
			t.addVertexWithUV(x+1, y+1, z  , u, v);
			
			// top
			setTexture(6);
			t.setNormal(0.0F, 1.0F, 0.0F);
			t.addVertexWithUV(x+1-thick, y+1, z+1, u+duv, v+duv);
			t.addVertexWithUV(x+1      , y+1, z+1, u+duv, v+duv2);
			t.addVertexWithUV(x+1      , y+1, z  , u, v+duv2);
			t.addVertexWithUV(x+1-thick, y+1, z  , u, v+duv);
			
			break;
		case Dir.NZ:
			// bottom
			setTexture(6);
			t.setNormal(0.0F, -1.0F, 0.0F);
			t.addVertexWithUV(x+1, y, z+1-thick, u+duv, v+duv);
			t.addVertexWithUV(x+1, y, z+1      , u+duv, v+duv2);
			t.addVertexWithUV(x  , y, z+1      , u, v+duv2);
			t.addVertexWithUV(x  , y, z+1-thick, u, v+duv);
			
			// X sides
			setTexture(7);
			t.setNormal(0.0F, 0.0F, -1.0F);
			t.addVertexWithUV(x, y  , z+1      , u+duv, v+duv);
			t.addVertexWithUV(x, y+1, z+1      , u+duv, v);
			t.addVertexWithUV(x, y+1, z+1-thick, u+duv2, v);
			t.addVertexWithUV(x, y  , z+1-thick, u+duv2, v+duv);
			
			t.setNormal(0.0F, 0.0F, 1.0F);
			t.addVertexWithUV(x+1, y  , z+1-thick, u+duv2, v+duv);
			t.addVertexWithUV(x+1, y+1, z+1-thick, u+duv2, v);
			t.addVertexWithUV(x+1, y+1, z+1      , u+duv, v);
			t.addVertexWithUV(x+1, y  , z+1      , u+duv, v+duv);
			
			// Back
			setTexture(1);
			t.setNormal(1.0F, 0.0F, 0.0F);
			t.addVertexWithUV(x  , y+1, z+1, u, v);
			t.addVertexWithUV(x  , y  , z+1, u, v+duv);
			t.addVertexWithUV(x+1, y  , z+1, u+duv, v+duv);
			t.addVertexWithUV(x+1, y+1, z+1, u+duv, v);
			
			// top
			setTexture(6);
			t.setNormal(0.0F, 1.0F, 0.0F);
			t.addVertexWithUV(x  , y+1, z+1-thick, u, v+duv);
			t.addVertexWithUV(x  , y+1, z+1, u, v+duv2);
			t.addVertexWithUV(x+1, y+1, z+1, u+duv, v+duv2);
			t.addVertexWithUV(x+1, y+1, z+1-thick, u+duv, v+duv);
			
			break;
		
		case Dir.PZ:
			// bottom
			setTexture(6);
			t.setNormal(0.0F, -1.0F, 0.0F);
			t.addVertexWithUV(x+1, y, z      , u+duv, v+duv);
			t.addVertexWithUV(x+1, y, z+thick, u+duv, v+duv2);
			t.addVertexWithUV(x  , y, z+thick, u, v+duv2);
			t.addVertexWithUV(x  , y, z      , u, v+duv);
			
			// Z sides
			setTexture(7);
			t.setNormal(0.0F, 0.0F, -1.0F);
			t.addVertexWithUV(x, y  , z+thick, u+duv, v+duv);
			t.addVertexWithUV(x, y+1, z+thick, u+duv, v);
			t.addVertexWithUV(x, y+1, z      , u+duv2, v);
			t.addVertexWithUV(x, y  , z      , u+duv2, v+duv);
			
			t.setNormal(0.0F, 0.0F, 1.0F);
			t.addVertexWithUV(x+1, y  , z      , u+duv2, v+duv);
			t.addVertexWithUV(x+1, y+1, z      , u+duv2, v);
			t.addVertexWithUV(x+1, y+1, z+thick, u+duv, v);
			t.addVertexWithUV(x+1, y  , z+thick, u+duv, v+duv);
			
			// Back
			setTexture(1);
			t.setNormal(-1.0F, 0.0F, 0.0F);
			t.addVertexWithUV(x+1, y+1, z, u+duv, v);
			t.addVertexWithUV(x+1, y  , z, u+duv, v+duv);
			t.addVertexWithUV(x  , y  , z, u, v+duv);
			t.addVertexWithUV(x  , y+1, z, u, v);
			
			// top
			setTexture(6);
			t.setNormal(0.0F, 1.0F, 0.0F);
			t.addVertexWithUV(x  , y+1, z      , u, v+duv);
			t.addVertexWithUV(x  , y+1, z+thick, u, v+duv2);
			t.addVertexWithUV(x+1, y+1, z+thick, u+duv, v+duv2);
			t.addVertexWithUV(x+1, y+1, z      , u+duv, v+duv);
			break;
		}
	}
	
	private static void renderRFIDReaderStatic(double x, double y, double z) {
		Tessellator t = Tessellator.instance;
		
		final float duv = 1/16.0f;
		final float thick = 16/16.0f; // height of the "base"
		final float corner = 0/16.0f; // insets at the top corners of the base
		
		// bottom
		setTexture(80);
		t.setNormal(0.0F, -1.0F, 0.0F);
		t.addVertexWithUV(x+1, y, z  , u+duv, v+duv);
		t.addVertexWithUV(x+1, y, z+1, u+duv, v);
		t.addVertexWithUV(x  , y, z+1, u, v);
		t.addVertexWithUV(x  , y, z  , u, v+duv);
		
		// sides
		setTexture(83);
		t.setNormal(0.0F, 0.0F, -1.0F);
		t.addVertexWithUV(x  , y        , z, u+duv, v+duv);
		t.addVertexWithUV(x+corner, y+thick  , z+corner, u+duv, v);
		t.addVertexWithUV(x+1-corner, y+thick  , z+corner, u, v);
		t.addVertexWithUV(x+1, y        , z, u, v+duv);
		
		t.setNormal(0.0F, 0.0F, 1.0F);
        t.addVertexWithUV(x+1-corner, y+thick  , z+1-corner, u, v);
		t.addVertexWithUV(x+corner, y+thick  , z+1-corner, u+duv, v);
		t.addVertexWithUV(x  , y        , z+1, u+duv, v+duv);
		t.addVertexWithUV(x+1, y        , z+1, u, v+duv);
		
		t.setNormal(-1.0F, 0.0F, 0.0F);
        t.addVertexWithUV(x+corner, y+thick  , z+corner, u, v);
		t.addVertexWithUV(x, y        , z, u, v+duv);
		t.addVertexWithUV(x, y        , z+1, u+duv, v+duv);
		t.addVertexWithUV(x+corner, y+thick  , z+1-corner, u+duv, v);
		
		t.setNormal(1.0F, 0.0F, 0.0F);
        t.addVertexWithUV(x+1-corner, y+thick  , z+corner, u, v);
		t.addVertexWithUV(x+1-corner, y+thick  , z+1-corner, u+duv, v);
		t.addVertexWithUV(x+1, y        , z+1, u+duv, v+duv);
		t.addVertexWithUV(x+1, y        , z  , u, v+duv);
		
		// top
		setTexture(80);
		t.setNormal(0.0F, 1.0F, 0.0F);
		t.addVertexWithUV(x+corner, y+thick, z+corner, u, v+duv);
		t.addVertexWithUV(x+corner, y+thick, z+1-corner, u, v);
		t.addVertexWithUV(x+1-corner, y+thick, z+1-corner, u+duv, v);
		t.addVertexWithUV(x+1-corner, y+thick, z+corner, u+duv, v+duv);
	}
	
	private static void renderMagStripeStatic(double x, double y, double z, int facing, int state) {
		Tessellator t = Tessellator.instance;
		
		final float duv = 1/16.0f;
		
		int facingTex = (facing == Dir.PY ? 112 : 96) + state;
		
		// bottom
		setTexture(80);
		t.setNormal(0.0F, -1.0F, 0.0F);
		t.addVertexWithUV(x+1, y, z  , u+duv, v+duv);
		t.addVertexWithUV(x+1, y, z+1, u+duv, v);
		t.addVertexWithUV(x  , y, z+1, u, v);
		t.addVertexWithUV(x  , y, z  , u, v+duv);
		
		// sides
		setTexture(facing == Dir.NZ ? facingTex : 1);
		t.setNormal(0.0F, 0.0F, -1.0F);
		t.addVertexWithUV(x  , y  , z, u+duv, v+duv);
		t.addVertexWithUV(x  , y+1, z, u+duv, v);
		t.addVertexWithUV(x+1, y+1, z, u, v);
		t.addVertexWithUV(x+1, y  , z, u, v+duv);
		
		setTexture(facing == Dir.PZ ? facingTex : 1);
		t.setNormal(0.0F, 0.0F, 1.0F);
        t.addVertexWithUV(x+1, y+1  , z+1, u+duv, v);
		t.addVertexWithUV(x, y+1  , z+1, u, v);
		t.addVertexWithUV(x  , y        , z+1, u, v+duv);
		t.addVertexWithUV(x+1, y        , z+1, u+duv, v+duv);
		
		setTexture(facing == Dir.NX ? facingTex : 1);
		t.setNormal(-1.0F, 0.0F, 0.0F);
        t.addVertexWithUV(x, y+1  , z, u, v);
		t.addVertexWithUV(x, y        , z, u, v+duv);
		t.addVertexWithUV(x, y        , z+1, u+duv, v+duv);
		t.addVertexWithUV(x, y+1  , z+1, u+duv, v);
		
		setTexture(facing == Dir.PX ? facingTex : 1);
		t.setNormal(1.0F, 0.0F, 0.0F);
        t.addVertexWithUV(x+1, y+1  , z, u+duv, v);
		t.addVertexWithUV(x+1, y+1  , z+1, u, v);
		t.addVertexWithUV(x+1, y        , z+1, u, v+duv);
		t.addVertexWithUV(x+1, y        , z  , u+duv, v+duv);
		
		// top
		setTexture(facing == Dir.PY ? facingTex : 80);
		t.setNormal(0.0F, 1.0F, 0.0F);
		t.addVertexWithUV(x, y+1, z, u, v+duv);
		t.addVertexWithUV(x, y+1, z+1, u, v);
		t.addVertexWithUV(x+1, y+1, z+1, u+duv, v);
		t.addVertexWithUV(x+1, y+1, z, u+duv, v+duv);
	}
}
/* $endif$ */