package immibis.ccperiphs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

/* $if mc > 1.3$ */
import cpw.mods.fml.common.network.IGuiHandler;
/* $endif$ */

import net.minecraft.src.*;
import net.minecraft.src.forge.*;
import net.minecraftforge.common.*;
import net.minecraftforge.client.*;
import immibis.ccperiphs.rfid.*;
//import immibis.ccperiphs.smartcard.TileSCInterface;
import immibis.core.Config;
import immibis.core.ModInfoReader;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.SidedProxy;

public class mod_ImmibisPeripherals extends PortableBaseMod {
	
	public static BlockPeriphs block;
	public static ItemCardBase itemRFID, itemMagStripe, itemSmartCard;
	public static mod_ImmibisPeripherals instance;
	public static File scBaseDir;
	
	public static final int GUI_RFID_WRITER = 0;
	
	public static String adminPassword;
	
	@Override
	public String getPriorities() {
		return "after:mod_ImmibisCore";
	}
	
	public mod_ImmibisPeripherals() {
		instance = this;
	}

	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/ccperiphs/mod_ImmibisPeripherals.info.txt", "version");
	}

	@SuppressWarnings("unchecked")
	@Override
	public void load() {
		IDAllocator.RegisterBlockID("peripherals.block", new IBlockIDCallback() {
			@Override
			public void registerBlock(int id) {
				block = new BlockPeriphs(id);
				ModLoader.registerBlock(block, ItemPeriphs.class);
			}
		});
		
		BlockPeriphs.model = SidedProxy.instance.getUniqueBlockModelID("immibis.ccperiphs.BlockRenderer", true);
		
		adminPassword = Config.getString("peripherals.adminPassword", "", Configuration.CATEGORY_GENERAL, "");
		
		if(adminPassword.isEmpty())
			adminPassword = null;
		
		itemRFID = new ItemCardBase(Config.getItemID("peripherals.rfid", 7434) - 256, 48);
		itemMagStripe = new ItemCardBase(Config.getItemID("peripherals.magstripe", 7435) - 256, 64);
		//itemSmartCard = new ItemCardBase(Config.getItemID("peripherals.smartcard", 7436) - 256, 80);
		
		ModLoader.addName(itemRFID, "RFID card");
		ModLoader.addName(itemMagStripe, "Mag-stripe card");
		//ModLoader.addName(itemSmartCard, "Smart card");
		
		CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemRFID.shiftedIndex));
		CraftingManager.getInstance().getRecipeList().add(new DyeCardRecipe(itemMagStripe.shiftedIndex));
		
		SidedProxy.instance.registerTileEntity(TileRFIDWriter.class, "immibis.cc-rfid.writer", "immibis.ccperiphs.rfid.RenderTileRFIDWriter");
		
		ModLoader.registerTileEntity(TileRFIDReader.class, "immibis.cc-rfid.reader");
		ModLoader.registerTileEntity(TileMagStripe.class, "immibis.cc-rfid.msreader");
		
		//ModLoader.registerTileEntity(TileSCInterface.class, "immibis.cc-sc.writer");
		//scBaseDir = new File(mod_ComputerCraft.getBaseDir(), "mod-data/immibis-peripherals/smartcard");
		//createFakeBaseDir();
	}
	
	private void createFakeBaseDir() {
		copyResourceToFileIfDoesntExist("/immibis/ccperiphs/smartcard/bios.lua", new File(scBaseDir, "mods/ComputerCraft/lua/bios.lua"));
	}

	private void copyResourceToFileIfDoesntExist(String respath, File file) {
		//if(file.exists())
		//	return;
		File parent = file.getParentFile();
		if(!parent.exists() && !parent.mkdirs())
			throw new RuntimeException("Failed to create "+parent);
		
		try {
			InputStream in = mod_ImmibisPeripherals.class.getResourceAsStream(respath);
			if(in == null)
				throw new RuntimeException("Failed to open resource "+respath);
			
			try {
				FileOutputStream out = new FileOutputStream(file);
				try {
					byte[] buf = new byte[102400];
					while(true) {
						int read = in.read(buf);
						if(read < 0)
							break;
						out.write(buf, 0, read);
					}
				} finally {
					out.close();
				}
			} finally {
				in.close();
			}
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void modsLoaded() {
		ModLoader.addRecipe(new ItemStack(itemRFID, 1, 0),
			"RRR",
			"PPP",
			"RRR",
			'P', Item.paper,
			'R', Item.redstone
		);
		ModLoader.addRecipe(new ItemStack(itemMagStripe, 1, 0),
			"PPP",
			"IRI",
			'P', Item.paper,
			'R', Item.redstone,
			'I', Item.ingotIron
		);
		ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_READER.ordinal()),
			" T ",
			"SIS",
			"SRS",
			'S', Block.stone,
			'T', Block.torchRedstoneActive,
			'R', Item.redstone,
			'I', Item.ingotIron
		);
		ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_WRITER.ordinal()),
			"L-L",
			"# #",
			"SRS",
			'S', Block.stone,
			'R', Item.redstoneRepeater,
			'#', Block.blockGold,
			'-', Block.thinGlass,
			'L', Block.redstoneLampIdle
		);
		ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.MAG_STRIPE.ordinal()),
			"STS",
			"SRS",
			"SSS",
			'S', Block.stone,
			'R', Item.redstone,
			'T', Block.torchRedstoneActive
		);
	}
}
