package immibis.ccperiphs.rfid;

import java.util.List;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ICrafting;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import immibis.core.api.porting.PortableContainer;

public class ContainerRFIDWriter extends PortableContainer {
	
	public TileRFIDWriter tile;

	public ContainerRFIDWriter(EntityPlayer player, TileRFIDWriter inv) {
		super(player, inv);
		this.tile = (TileRFIDWriter)inv;
		
		addSlot(new Slot(inv, 0, 85, 22));
		
		for(int x = 0; x < 9; x++) {
			for(int y = 0; y < 3; y++)
				addSlot(new Slot(player.inventory, x + y*9 + 9, 13 + 18*x, 66 + 18*y));
			addSlot(new Slot(player.inventory, x, 13 + 18*x, 124));
		}
	}
	
	@Override
	public ItemStack transferStackInSlot(int n) {return null;}
	
	private int lastProgress = -1;
	
	@Override
	public void updateCraftingResults() {
		super.updateCraftingResults();
		
		if(tile.progress != lastProgress) {
			for(ICrafting ic : (List<ICrafting>)crafters)
				ic.updateCraftingInventoryInfo(this, 0, tile.progress);
			
			lastProgress = tile.progress;
		}
	}
	
	// @Override
	public void updateProgressBar(int i, int j) {
		if(i == 0)
			tile.progress = j;
	}

}
