package immibis.ccperiphs.rfid;

/* $if jclient$ */

import immibis.ccperiphs.RenderUtils;
import immibis.core.aspects.ClientOnly;

import org.lwjgl.opengl.GL11;

import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySpecialRenderer;
import net.minecraft.src.forge.*;
import net.minecraftforge.client.*;

@ClientOnly
public class RenderTileRFIDWriter extends TileEntitySpecialRenderer {

	@Override
	public void renderTileEntityAt(TileEntity teRaw, double x, double y, double z, float partialTick) {
		immibis.core.RenderUtils.setBrightness(teRaw.worldObj, teRaw.xCoord, teRaw.yCoord, teRaw.zCoord);
		
		GL11.glPushMatrix();
		GL11.glTranslated(x, y, z);
		
		TileRFIDWriter te = (TileRFIDWriter)teRaw;
		
		/* $if mc < 1.3$
		MinecraftForgeClient.bindTexture("/immibis/ccperiphs/world.png");
		$else$ */
		ForgeHooksClient.bindTexture("/immibis/ccperiphs/world.png", 0);
		/* $endif$ */
		GL11.glDisable(GL11.GL_CULL_FACE);
		GL11.glDisable(GL11.GL_LIGHTING);
		
		float interpLid = te.lidClosedAmt + TileRFIDWriter.LID_RATE * partialTick * (te.state == TileRFIDWriter.STATE_RUN ? 1 : -1);
		interpLid = Math.min(Math.max(interpLid, 0), 1);
		
		RenderUtils.renderRFIDWriterDynamic(te.facing, interpLid, te.visualProgress, te.state != TileRFIDWriter.STATE_EMPTY, te.state == TileRFIDWriter.STATE_RUN, te.heldCardColour);
		GL11.glEnable(GL11.GL_CULL_FACE);
		/* $if mc < 1.3$
		MinecraftForgeClient.unbindTexture();
		$else$ */
		ForgeHooksClient.unbindTexture();
		/* $endif$ */
		
		GL11.glPopMatrix();
	}

}

/* $endif$ */