package immibis.ccperiphs.rfid;

import java.util.List;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.mod_ImmibisPeripherals;

public class TileRFIDReader extends TilePeriphs implements IPeripheral {
	public static final double RADIUS = 5;
	public static final double MIN_RADIUS = 1;
	public static final int TICKS_PER_SCAN = 20;
	
	// Not saved with NBT, so the device resets, the same way computers do.
	// Intentional as long as computers reboot on unload.
	private int ticksRemaining = 0, scanTicks = 0;
	private double scanRadius;
	private IComputerAccess scanningComputer = null;

	
	private void doScan(IComputerAccess comp, IInventory inv) {
		int size = inv.getSizeInventory();
		for(int k = 0; k < size; k++) {
			ItemStack st = inv.getStackInSlot(k);
			if(st != null && st.itemID == mod_ImmibisPeripherals.itemRFID.shiftedIndex && st.stackTagCompound != null && st.stackTagCompound.hasKey("data")) {
				comp.queueEvent("rfid_detected", new Object[] {st.stackTagCompound.getString("data")});
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	private void doScan(IComputerAccess comp) {
		/* $if mc < 1.3$
		AxisAlignedBB aabb = AxisAlignedBB.getBoundingBoxFromPool(xCoord + 0.5 - scanRadius, yCoord + 0.5 - scanRadius, zCoord + 0.5 - scanRadius, xCoord + 0.5 + scanRadius, yCoord + 0.5 + scanRadius, zCoord + 0.5 + scanRadius);
		$else$ */
		AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox(xCoord + 0.5 - scanRadius, yCoord + 0.5 - scanRadius, zCoord + 0.5 - scanRadius, xCoord + 0.5 + scanRadius, yCoord + 0.5 + scanRadius, zCoord + 0.5 + scanRadius);
		/* $endif$ */
		List players = worldObj.getEntitiesWithinAABB(EntityPlayer.class, aabb);
		players.addAll(worldObj.getEntitiesWithinAABB(EntityMinecart.class, aabb));
		
		double scanRadiusSq = scanRadius*scanRadius;
		for(Entity e : (List<Entity>)players) {
			if(e.getDistanceSq(xCoord + 0.5, yCoord + 0.5, zCoord + 0.5) > scanRadiusSq)
				continue;
			
			if(e instanceof EntityPlayer)
				doScan(comp, ((EntityPlayer)e).inventory);
			else if(e instanceof IInventory)
				doScan(comp, (IInventory)e);
		}
		
		comp.queueEvent("rfid_scan_done");
	}
	
	
	@Override
	public String getType() {
		return "rfid reader";
	}
	
	private static String[] methodNames = {
		"scan",
		"getProgress",
		"isScanning"
	};

	@Override
	public String[] getMethodNames() {
		return methodNames;
	}
	
	@Override
	public void updateEntity() {
		if(ticksRemaining > 0) {
			ticksRemaining--;
			if(ticksRemaining == 0 && scanningComputer != null) {
				doScan(scanningComputer);
				scanningComputer = null;
			}
		}
	}

	@Override
	public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
		switch(method) {
		case 0: // scan
			if(ticksRemaining > 0)
				return new Object[] {false, "Already scanning"};
			if(arguments.length == 0 || !(arguments[0] instanceof Number)) {
				scanRadius = RADIUS;
				scanTicks = TICKS_PER_SCAN;
			} else {
				scanRadius = ((Number)arguments[0]).doubleValue();
				if(scanRadius < MIN_RADIUS)
					return new Object[] {false, "Radius too low, minimum is "+MIN_RADIUS};
				if(scanRadius > RADIUS)
					return new Object[] {false, "Radius too high, maximum is "+RADIUS};
				scanTicks = (int)(TICKS_PER_SCAN * scanRadius / RADIUS);
			}
			ticksRemaining = scanTicks;
			scanningComputer = computer;
			return new Object[] {true};
		case 1: // getProgress
			if(ticksRemaining == 0)
				return new Object[] {-1};
			return new Object[] {1 - ticksRemaining / (double)scanTicks};
		case 2: // isScanning
			return new Object[] {ticksRemaining > 0};
		}
		return new Object[0];
	}

	@Override
	public boolean canAttachToSide(int side) {
		return true;
	}

	@Override
	public void attach(IComputerAccess computer, String computerSide) {
			
	}

	@Override
	public void detach(IComputerAccess computer) {
		if(computer == scanningComputer) {
			scanningComputer = null;
			ticksRemaining = 0;
		}
	}
}
