package immibis.ccperiphs;

import immibis.ccperiphs.rfid.TileRFIDWriter;
import immibis.core.BlockCombined;
import java.util.ArrayList;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class BlockPeriphs extends BlockCombined
{
    public static int model;

    private static int[] $SWITCH_TABLE$immibis$ccperiphs$EnumPeriphs;

    public BlockPeriphs(int var1)
    {
        super(var1, Material.ORE, "/immibis/ccperiphs/world.png");
    }

    /**
     * Updates the blocks bounds based on its current state. Args: world, x, y, z
     */
    public void updateShape(IBlockAccess var1, int var2, int var3, int var4)
    {
        EnumPeriphs var5 = EnumPeriphs.values()[var1.getData(var2, var3, var4)];
        TileEntity var6 = var1.getTileEntity(var2, var3, var4);

        switch ($SWITCH_TABLE$immibis$ccperiphs$EnumPeriphs()[var5.ordinal()])
        {
            case 1:
                if (var6 == null)
                {
                    return;
                }
                else
                {
                    switch (((TileRFIDWriter)var6).facing)
                    {
                        case 1:
                            this.a(0.0F, 0.0F, 0.0F, 1.0F, 0.5625F, 1.0F);
                            return;

                        case 2:
                            this.a(0.0F, 0.0F, 0.4375F, 1.0F, 1.0F, 1.0F);
                            return;

                        case 3:
                            this.a(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 0.5625F);
                            return;

                        case 4:
                            this.a(0.4375F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
                            return;

                        case 5:
                            this.a(0.0F, 0.0F, 0.0F, 0.5625F, 1.0F, 1.0F);
                            return;

                        default:
                            return;
                    }
                }

            default:
                this.a(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
        }
    }

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public int a(int var1, int var2)
    {
        return 0;
    }

    /**
     * Is this block (a) opaque and (b) a full 1m cube?  This determines whether or not to render the shared face of two
     * adjacent blocks and also whether the player can attach torches, redstone wire, etc to this block.
     */
    public boolean a()
    {
        return false;
    }

    /**
     * If this block doesn't render as an ordinary block it will return False (examples: signs, buttons, stairs, etc)
     */
    public boolean b()
    {
        return false;
    }

    /**
     * Returns Returns true if the given side of this block type should be rendered (if it's solid or not), if the
     * adjacent block is at the given coordinates. Args: blockAccess, x, y, z, side
     */
    public boolean b(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        return false;
    }

    /**
     * Returns a bounding box from the pool of bounding boxes (this means this box can change after the pool has been
     * cleared to be reused)
     */
    public AxisAlignedBB e(World var1, int var2, int var3, int var4)
    {
        this.updateShape(var1, var2, var3, var4);
        return super.e(var1, var2, var3, var4);
    }

    /**
     * The type of render function that is called for this block
     */
    public int c()
    {
        return model;
    }

    public TileEntity getBlockEntity(int var1)
    {
        return EnumPeriphs.values()[var1].createTile();
    }

    public void addCreativeItems(ArrayList var1)
    {
        EnumPeriphs[] var5;
        int var4 = (var5 = EnumPeriphs.values()).length;

        for (int var3 = 0; var3 < var4; ++var3)
        {
            EnumPeriphs var2 = var5[var3];
            var1.add(new ItemStack(this, 1, var2.ordinal()));
        }
    }

    static int[] $SWITCH_TABLE$immibis$ccperiphs$EnumPeriphs()
    {
        if ($SWITCH_TABLE$immibis$ccperiphs$EnumPeriphs != null)
        {
            return $SWITCH_TABLE$immibis$ccperiphs$EnumPeriphs;
        }
        else
        {
            int[] var0 = new int[EnumPeriphs.values().length];

            try
            {
                var0[EnumPeriphs.MAG_STRIPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError var4)
            {
                ;
            }

            try
            {
                var0[EnumPeriphs.RFID_READER.ordinal()] = 2;
            }
            catch (NoSuchFieldError var3)
            {
                ;
            }

            try
            {
                var0[EnumPeriphs.RFID_WRITER.ordinal()] = 1;
            }
            catch (NoSuchFieldError var2)
            {
                ;
            }

            try
            {
                var0[EnumPeriphs.SPEAKER.ordinal()] = 4;
            }
            catch (NoSuchFieldError var1)
            {
                ;
            }

            $SWITCH_TABLE$immibis$ccperiphs$EnumPeriphs = var0;
            return var0;
        }
    }
}
