package immibis.ccperiphs.forth;

import java.util.Iterator;

public class ForthBaseDictionary extends JavaDictionary
{
    public ForthBaseDictionary()
    {
        this.addWord(1, "WORDS", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                String var2 = "Forth:";
                String var3;
                Iterator var4;

                for (var4 = var1.forth_dict.keySet().iterator(); var4.hasNext(); var2 = var2 + " " + var3)
                {
                    var3 = (String)var4.next();
                }

                var1.writeWrapped(var2);
                var2 = "Java:";

                for (var4 = var1.java_dict.getAllWords().iterator(); var4.hasNext(); var2 = var2 + " " + var3)
                {
                    var3 = (String)var4.next();
                }

                var1.writeWrapped(var2);
                var2 = "Base: ; :";

                for (var4 = ForthBaseDictionary.this.getAllWords().iterator(); var4.hasNext(); var2 = var2 + " " + var3)
                {
                    var3 = (String)var4.next();
                }

                var1.writeWrapped(var2);
            }
        });
        this.addWord(2, "PAGE", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.write("\n\n\n\n\n\n\n\n\n\n");
            }
        });
        this.addWord(3, ".", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.write(var1.pop() + " ");
            }
        });
        this.addWord(4, "(lit)", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.nextCode()));
            }
        });
        this.addWord(5, "(lit2)", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                short var2 = var1.nextCode();
                short var3 = var1.nextCode();
                var1.push(Integer.valueOf((var2 & 65535) + ((var3 & 65535) << 16)));
            }
        });
        this.addWord(6, "RETURN", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.doReturn();
            }
        });
        this.addWord(7, "CR", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.write("\n");
            }
        });
        this.addWord(8, "DUP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                var1.push(var2);
                var1.push(var2);
            }
        });
        this.addWord(9, "?DUP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                var1.push(var2);

                if (var2 != null && (!(var2 instanceof Number) || !((Number)var2).equals(Integer.valueOf(0))))
                {
                    var1.push(var2);
                }
            }
        });
        this.addWord(10, "2DUP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                var1.push(var3);
                var1.push(var2);
                var1.push(var3);
                var1.push(var2);
            }
        });
        this.addWord(11, "DROP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.pop();
            }
        });
        this.addWord(12, "2DROP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.pop();
                var1.pop();
            }
        });
        this.addWord(13, "SWAP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                var1.push(var2);
                var1.push(var3);
            }
        });
        this.addWord(14, "2SWAP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                Object var4 = var1.pop();
                Object var5 = var1.pop();
                var1.push(var3);
                var1.push(var2);
                var1.push(var5);
                var1.push(var4);
            }
        });
        this.addWord(16, "OVER", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                var1.push(var3);
                var1.push(var2);
                var1.push(var3);
            }
        });
        this.addWord(17, "2OVER", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                Object var4 = var1.pop();
                Object var5 = var1.pop();
                var1.push(var5);
                var1.push(var4);
                var1.push(var3);
                var1.push(var2);
                var1.push(var5);
                var1.push(var4);
            }
        });
        this.addWord(18, "ROT", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                Object var4 = var1.pop();
                var1.push(var3);
                var1.push(var2);
                var1.push(var4);
            }
        });
        this.addWord(19, "-ROT", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                Object var4 = var1.pop();
                var1.push(var2);
                var1.push(var4);
                var1.push(var3);
            }
        });
        this.addWord(20, "NIP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                var1.pop();
                var1.push(var2);
            }
        });
        this.addWord(21, "TUCK", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                Object var2 = var1.pop();
                Object var3 = var1.pop();
                var1.push(var2);
                var1.push(var3);
                var1.push(var2);
            }
        });
        this.addWord(22, "DO", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                int var4 = var1.rpop();
                var1.rpush(var2);
                var1.rpush(var3);
                var1.rpush(var4);
                var1.rpush(var4);
            }
        });
        this.addWord(24, "LOOP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                ForthBaseDictionary.this.LOOP(var1, 1);
            }
        });
        this.addWord(25, "+LOOP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                ForthBaseDictionary.this.LOOP(var1, var1.popInt());
            }
        });
        this.addWord(27, "BEGIN", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Short.valueOf(var1.HERE()));
            }
        });
        this.addWord(28, "UNTIL", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.compileWord("(!?branch)");
                var1.appendCode((short)var1.popInt());
            }
        });
        this.addWord(29, "WHILE", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                var1.compileWord("(!?branch)");
                short var3 = var1.HERE();
                var1.appendCode((short)0);
                var1.push(Integer.valueOf(var3));
                var1.push(Integer.valueOf(var2));
            }
        });
        this.addWord(30, "REPEAT", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.compileWord("(branch)");
                var1.appendCode((short)var1.popInt());
                var1.writeCode(var1.popInt(), var1.HERE());
            }
        });
        this.addWord(31, "AGAIN", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.compileWord("(branch)");
                var1.appendCode((short)var1.popInt());
            }
        });
        this.addWord(32, "UNLOOP", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                ForthBaseDictionary.this.UNLOOP(var1);
            }
        });
        this.addWord(33, "IF", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.compileWord("(!?branch)");
                var1.push(Short.valueOf(var1.HERE()));
                var1.appendCode((short)0);
            }
        });
        this.addWord(34, "THEN", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.writeCode(var1.popInt(), var1.HERE());
            }
        });
        this.addWord(35, "ELSE", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                var1.compileWord("(branch)");
                var1.push(Short.valueOf(var1.HERE()));
                var1.appendCode((short)0);
                var1.writeCode(var2, var1.HERE());
            }
        });
        this.addWord(36, "0=", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() == 0 ? -1 : 0));
            }
        });
        this.addWord(37, "0<>", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() != 0 ? -1 : 0));
            }
        });
        this.addWord(38, "0<", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() < 0 ? -1 : 0));
            }
        });
        this.addWord(39, "0>", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() > 0 ? -1 : 0));
            }
        });
        this.addWord(40, "<>", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 != var3 ? -1 : 0));
            }
        });
        this.addWord(41, ">", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 > var3 ? -1 : 0));
            }
        });
        this.addWord(42, "<", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 < var3 ? -1 : 0));
            }
        });
        this.addWord(43, ">=", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 >= var3 ? -1 : 0));
            }
        });
        this.addWord(44, "<=", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 <= var3 ? -1 : 0));
            }
        });
        this.addWord(45, "=", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 == var3 ? -1 : 0));
            }
        });
        this.addWord(46, "+", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 + var3));
            }
        });
        this.addWord(47, "-", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 - var3));
            }
        });
        this.addWord(48, "/", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 / var3));
            }
        });
        this.addWord(49, "MOD", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 % var3));
            }
        });
        this.addWord(50, "1+", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() + 1));
            }
        });
        this.addWord(51, "1-", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() - 1));
            }
        });
        this.addWord(52, "NEGATE", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(-var1.popInt()));
            }
        });
        this.addWord(53, "MAX", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(Math.max(var1.popInt(), var1.popInt())));
            }
        });
        this.addWord(54, "MIN", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(Math.min(var1.popInt(), var1.popInt())));
            }
        });
        this.addWord(55, "AND", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() & var1.popInt()));
            }
        });
        this.addWord(56, "OR", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() | var1.popInt()));
            }
        });
        this.addWord(57, "XOR", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() ^ var1.popInt()));
            }
        });
        this.addWord(58, "INVERT", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(~var1.popInt()));
            }
        });
        this.addWord(59, "TRUE", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(-1));
            }
        });
        this.addWord(60, "FALSE", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(0));
            }
        });
        this.addWord(61, "2*", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() * 2));
            }
        });
        this.addWord(62, "2/", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.popInt() / 2));
            }
        });
        this.addWord(63, "I", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.rpick(3)));
            }
        });
        this.addWord(64, "J", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Integer.valueOf(var1.rpick(6)));
            }
        });
        this.addWord(65, "\\", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.getTIB().nextLine();
            }
        });
        this.addWord(66, "(", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.getTIB().next("[^)]*)");
            }
        });
        this.addWord(67, "*", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.push(Integer.valueOf(var2 * var3));
            }
        });
        this.addWord(68, "(branch)", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.jump(var1.nextCode());
            }
        });
        this.addWord(69, "(?branch)", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                if (var1.popInt() != 0)
                {
                    var1.jump(var1.nextCode());
                }
                else
                {
                    var1.nextCode();
                }
            }
        });
        this.addWord(70, "(!?branch)", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();

                if (var2 == 0)
                {
                    var1.jump(var1.nextCode());
                }
                else
                {
                    var1.nextCode();
                }
            }
        });
        this.addWord(71, "VARIABLE", new IImmediateWord()
        {
            public void execute(ForthContext var1)
            {
                var1.createWordHere(var1.readWord());
                var1.compileWord("(lit)");
                var1.appendCode((short)(var1.HERE() + 2));
                var1.compileWord("RETURN");
                var1.appendCode((short)0);
                var1.endDefinition();
            }
        });
        this.addWord(72, "@", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.push(Short.valueOf(var1.readCode(var1.popInt())));
            }
        });
        this.addWord(73, "!", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                int var2 = var1.popInt();
                int var3 = var1.popInt();
                var1.writeCode(var2, (short)var3);
            }
        });
        this.addWord(74, "TICK", new IJavaWord()
        {
            public void execute(ForthContext var1)
            {
                var1.waitForNextTick();
            }
        });
    }

    private void UNLOOP(ForthContext var1)
    {
        int var2 = var1.rpop();
        var1.rpop();
        var1.rpop();
        var1.rpop();
        var1.rpush(var2);
    }

    private void LOOP(ForthContext var1, int var2)
    {
        int var3 = var1.rpick(2);
        int var4 = var1.rpick(3);
        var4 += var2;
        var1.rset(3, var4);

        if ((var4 > var3 || var2 >= 0) && (var4 < var3 || var2 <= 0))
        {
            var1.rset(0, var1.rpick(1));
        }
        else
        {
            this.UNLOOP(var1);
        }
    }
}
