package immibis.ccperiphs.forth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JavaDictionary
{
    private Map words_by_id = new HashMap();
    private Map ids_by_name = new HashMap();

    public Set getAllWords()
    {
        return Collections.unmodifiableSet(this.ids_by_name.keySet());
    }

    public void addWord(int var1, String var2, IJavaWord var3)
    {
        if (var1 > 0 && var1 < 16384)
        {
            short var4 = (short)var1;
            this.words_by_id.put(Short.valueOf(var4), var3);
            this.ids_by_name.put(var2, Short.valueOf(var4));
        }
        else
        {
            throw new RuntimeException("word IDs must be between 1 and 16383 inclusive");
        }
    }

    public short getId(String var1)
    {
        Short var2 = (Short)this.ids_by_name.get(var1);
        return var2 == null ? 0 : var2.shortValue();
    }

    public IJavaWord getWord(short var1)
    {
        return (IJavaWord)this.words_by_id.get(Short.valueOf(var1));
    }
}
