package immibis.ccperiphs;

import immibis.ccperiphs.rfid.DyeCardRecipe;
import immibis.ccperiphs.rfid.ItemCardBase;
import immibis.ccperiphs.rfid.TileMagStripe;
import immibis.ccperiphs.rfid.TileRFIDReader;
import immibis.ccperiphs.rfid.TileRFIDWriter;
import immibis.ccperiphs.speaker.PacketSpeakerStart;
import immibis.ccperiphs.speaker.PacketSpeakerStop;
import immibis.ccperiphs.speaker.PacketSpeakerStream;
import immibis.ccperiphs.speaker.TileSpeaker;
import immibis.ccperiphs.tape.ItemTape;
import immibis.core.Config;
import immibis.core.ModInfoReader;
import immibis.core.api.IBlockIDCallback;
import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.SidedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.server.Block;
import net.minecraft.server.CraftingManager;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ModLoader;

public class mod_ImmibisPeripherals extends PortableBaseMod implements IPacketMap
{
    public static BlockPeriphs block;
    public static ItemCardBase itemRFID;
    public static ItemCardBase itemMagStripe;
    public static ItemCardBase itemSmartCard;
    public static ItemTape itemTape;
    public static mod_ImmibisPeripherals instance;
    public static File scBaseDir;
    public static final int GUI_RFID_WRITER = 0;
    public static int maxTapeSizeKB = 65536;
    public static final int PKT_SPEAKER_STOP = 1;
    public static final int PKT_SPEAKER_START = 2;
    public static final int PKT_SPEAKER_STREAM = 3;
    public static String adminPassword;
    public static final String CHANNEL = "ImmPhs";

    public String getPriorities()
    {
        return "after:mod_ImmibisCore";
    }

    public mod_ImmibisPeripherals()
    {
        instance = this;
    }

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/immibis/ccperiphs/mod_ImmibisPeripherals.info.txt", "version");
    }

    public void load()
    {
        IDAllocator.RegisterBlockID("peripherals.block", new IBlockIDCallback()
        {
            public void registerBlock(int var1)
            {
                mod_ImmibisPeripherals.block = new BlockPeriphs(var1);
                ModLoader.registerBlock(mod_ImmibisPeripherals.block, ItemPeriphs.class);
            }
        });
        BlockPeriphs.model = SidedProxy.instance.getUniqueBlockModelID("immibis.ccperiphs.BlockRenderer", true);
        adminPassword = Config.getString("peripherals.adminPassword", "", "general", "");

        if (adminPassword.isEmpty())
        {
            adminPassword = null;
        }

        itemRFID = new ItemCardBase(Config.getItemID("peripherals.rfid", 7434) - 256, 48);
        itemMagStripe = new ItemCardBase(Config.getItemID("peripherals.magstripe", 7435) - 256, 64);
        ModLoader.addName(itemRFID, "RFID card");
        ModLoader.addName(itemMagStripe, "Mag-stripe card");
        CraftingManager.getInstance().getRecipies().add(new DyeCardRecipe(itemRFID.id));
        CraftingManager.getInstance().getRecipies().add(new DyeCardRecipe(itemMagStripe.id));
        SidedProxy.instance.registerTileEntity(TileRFIDWriter.class, "immibis.cc-rfid.writer", "immibis.ccperiphs.rfid.RenderTileRFIDWriter");
        ModLoader.registerTileEntity(TileRFIDReader.class, "immibis.cc-rfid.reader");
        ModLoader.registerTileEntity(TileMagStripe.class, "immibis.cc-rfid.msreader");
        SidedProxy.instance.registerTileEntity(TileSpeaker.class, "immibis.cc-speaker", "immibis.ccperiphs.speaker.RenderTileSpeaker");
        OneTwoFiveNetworking.initReceiveClient(this, "ImmPhs");
    }

    private void createFakeBaseDir()
    {
        this.copyResourceToFileIfDoesntExist("/immibis/ccperiphs/smartcard/bios.lua", new File(scBaseDir, "mods/ComputerCraft/lua/bios.lua"));
    }

    private void copyResourceToFileIfDoesntExist(String var1, File var2)
    {
        File var3 = var2.getParentFile();

        if (!var3.exists() && !var3.mkdirs())
        {
            throw new RuntimeException("Failed to create " + var3);
        }
        else
        {
            try
            {
                InputStream var4 = mod_ImmibisPeripherals.class.getResourceAsStream(var1);

                if (var4 == null)
                {
                    throw new RuntimeException("Failed to open resource " + var1);
                }
                else
                {
                    try
                    {
                        FileOutputStream var5 = new FileOutputStream(var2);

                        try
                        {
                            byte[] var6 = new byte[102400];

                            while (true)
                            {
                                int var7 = var4.read(var6);

                                if (var7 < 0)
                                {
                                    return;
                                }

                                var5.write(var6, 0, var7);
                            }
                        }
                        finally
                        {
                            var5.close();
                        }
                    }
                    finally
                    {
                        var4.close();
                    }
                }
            }
            catch (IOException var18)
            {
                throw new RuntimeException(var18);
            }
        }
    }

    public void modsLoaded()
    {
        if (Config.getBoolean("peripherals.enableCraftingRFIDCards", true))
        {
            ModLoader.addRecipe(new ItemStack(itemRFID, 1, 0), new Object[] {"RRR", "PPP", "RRR", 'P', Item.PAPER, 'R', Item.REDSTONE});
        }

        if (Config.getBoolean("peripherals.enableCraftingMagCards", true))
        {
            ModLoader.addRecipe(new ItemStack(itemMagStripe, 1, 0), new Object[] {"PPP", "IRI", 'P', Item.PAPER, 'R', Item.REDSTONE, 'I', Item.IRON_INGOT});
        }

        if (Config.getBoolean("peripherals.enableCraftingRFIDReader", true))
        {
            ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_READER.ordinal()), new Object[] {" T ", "SIS", "SRS", 'S', Block.STONE, 'T', Block.REDSTONE_TORCH_ON, 'R', Item.REDSTONE, 'I', Item.IRON_INGOT});
        }

        if (Config.getBoolean("peripherals.enableCraftingRFIDWriter", true))
        {
            ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.RFID_WRITER.ordinal()), new Object[] {"L-L", "# #", "SRS", 'S', Block.STONE, 'R', Item.DIODE, '#', Block.GOLD_BLOCK, '-', Block.THIN_GLASS, 'L', Block.REDSTONE_LAMP_OFF});
        }

        if (Config.getBoolean("peripherals.enableCraftingMagCardDevice", true))
        {
            ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.MAG_STRIPE.ordinal()), new Object[] {"STS", "SRS", "SSS", 'S', Block.STONE, 'R', Item.REDSTONE, 'T', Block.REDSTONE_TORCH_ON});
        }

        if (Config.getBoolean("peripherals.enableCraftingSpeaker", true))
        {
            ModLoader.addRecipe(new ItemStack(block, 1, EnumPeriphs.SPEAKER.ordinal()), new Object[] {"S#S", "SNS", "SNS", 'S', Block.STONE, 'N', Block.NOTE_BLOCK, '#', Block.IRON_BLOCK});
        }
    }

    public IPacket createPacket(byte var1)
    {
        switch (var1)
        {
            case 1:
                return new PacketSpeakerStop();

            case 2:
                return new PacketSpeakerStart();

            case 3:
                return new PacketSpeakerStream();

            default:
                return null;
        }
    }
}
