package immibis.ccperiphs.rfid;

import immibis.core.api.porting.PortableContainer;
import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ICrafting;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Slot;

public class ContainerRFIDWriter extends PortableContainer
{
    public TileRFIDWriter tile;
    private int lastProgress = -1;

    public ContainerRFIDWriter(EntityHuman var1, TileRFIDWriter var2)
    {
        super(var1, var2);
        this.tile = var2;
        this.a(new Slot(var2, 0, 85, 22));

        for (int var3 = 0; var3 < 9; ++var3)
        {
            for (int var4 = 0; var4 < 3; ++var4)
            {
                this.a(new Slot(var1.inventory, var3 + var4 * 9 + 9, 13 + 18 * var3, 66 + 18 * var4));
            }

            this.a(new Slot(var1.inventory, var3, 13 + 18 * var3, 124));
        }
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack a(int var1)
    {
        return null;
    }

    /**
     * Updates crafting matrix; called from onCraftMatrixChanged. Args: none
     */
    public void a()
    {
        super.a();

        if (this.tile.progress != this.lastProgress)
        {
            Iterator var2 = this.listeners.iterator();

            while (var2.hasNext())
            {
                ICrafting var1 = (ICrafting)var2.next();
                var1.setContainerData(this, 0, this.tile.progress);
            }

            this.lastProgress = this.tile.progress;
        }
    }

    public void updateProgressBar(int var1, int var2)
    {
        if (var1 == 0)
        {
            this.tile.progress = var2;
        }
    }
}
