package immibis.ccperiphs.rfid;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.mod_ImmibisPeripherals;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;

public class TileMagStripe extends TilePeriphs implements IPeripheral
{
    public static final int MAX_DATA_LENGTH = 100;
    public static final int MAX_LABEL_LENGTH = 20;
    private Set computers = new HashSet();
    public byte facing;
    private String writeData;
    private String writeLabel;
    public static final int STATE_OFF = 0;
    public static final int STATE_IDLE = 1;
    public static final int STATE_READ_WAIT = 2;
    public static final int STATE_WRITE_WAIT = 3;
    public static final int STATE_WRITE = 4;
    public int state;
    private boolean insertCardLight;
    private static String[] methodNames = new String[] {"beginWrite", "cancelWrite", "isWaiting", "setInsertCardLight"};

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setByte("facing", this.facing);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.facing = var1.getByte("facing");
    }

    private void updateState()
    {
        int var1;

        if (this.computers.size() == 0)
        {
            var1 = 0;
        }
        else if (this.writeData != null)
        {
            var1 = this.insertCardLight ? 3 : 4;
        }
        else
        {
            var1 = this.insertCardLight ? 2 : 1;
        }

        if (this.state != var1)
        {
            this.state = var1;
            this.world.notify(this.x, this.y, this.z);
        }
    }

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        Packet132TileEntityData var1 = new Packet132TileEntityData();
        var1.d = this.facing & 7 | this.state << 4;
        var1.lowPriority = true;
        var1.a = this.x;
        var1.b = this.y;
        var1.c = this.z;
        return var1;
    }

    public void onDataPacket(Packet132TileEntityData var1)
    {
        this.facing = (byte)(var1.d & 7);
        this.state = var1.d >> 4 & 15;
    }

    public String getType()
    {
        return "mag card reader";
    }

    public String[] getMethodNames()
    {
        return methodNames;
    }

    public Object[] callMethod(IComputerAccess var1, int var2, Object[] var3) throws Exception
    {
        switch (var2)
        {
            case 0:
                if (var3.length != 2)
                {
                    return new Object[] {Boolean.valueOf(false), "Expected two arguments"};
                }

                if (var3[0] instanceof String && var3[1] instanceof String)
                {
                    if (this.writeData != null)
                    {
                        return new Object[] {Boolean.valueOf(false), "Already writing"};
                    }

                    this.writeData = (String)var3[0];
                    this.writeLabel = (String)var3[1];

                    if (this.writeData.length() > 100)
                    {
                        this.writeData = this.writeLabel = null;
                        return new Object[] {Boolean.valueOf(false), "Max data length is 100 chars"};
                    }

                    if (this.writeLabel.length() > 20)
                    {
                        this.writeData = this.writeLabel = null;
                        return new Object[] {Boolean.valueOf(false), "Max label length is 20 chars"};
                    }

                    this.updateState();
                    return new Object[] {Boolean.valueOf(true)};
                }

                return new Object[] {Boolean.valueOf(false), "Expected string"};

            case 1:
                this.writeData = null;
                this.writeLabel = null;
                this.updateState();
                break;

            case 2:
                return new Object[] {Boolean.valueOf(this.writeData != null)};
            case 3:
                if (var3.length == 1 && var3[0] instanceof Boolean)
                {
                    this.insertCardLight = ((Boolean)var3[0]).booleanValue();
                    this.updateState();
                }
        }

        return new Object[0];
    }

    public boolean canAttachToSide(int var1)
    {
        return true;
    }

    public void attach(IComputerAccess var1, String var2)
    {
        this.computers.add(var1);
        this.updateState();
    }

    public void detach(IComputerAccess var1)
    {
        this.computers.remove(var1);

        if (this.computers.size() == 0)
        {
            this.writeData = null;
        }

        this.updateState();
    }

    public boolean onBlockActivated(EntityHuman var1)
    {
        ItemStack var2 = var1.U();

        if (var2 != null && var2.id == mod_ImmibisPeripherals.itemMagStripe.id)
        {
            if (this.writeData != null)
            {
                if (var2.tag == null)
                {
                    var2.tag = new NBTTagCompound();
                }

                var2.tag.setString("data", this.writeData);
                var2.tag.setString("line1", this.writeLabel);
                Iterator var4 = this.computers.iterator();

                while (var4.hasNext())
                {
                    IComputerAccess var3 = (IComputerAccess)var4.next();
                    var3.queueEvent("mag_write_done");
                }

                this.writeData = null;
                this.writeLabel = null;
                this.updateState();
            }
            else
            {
                String var7 = "";

                if (var2.tag != null)
                {
                    var7 = var2.tag.getString("data");
                }

                Object[] var8 = new Object[] {var7};
                Iterator var6 = this.computers.iterator();

                while (var6.hasNext())
                {
                    IComputerAccess var5 = (IComputerAccess)var6.next();
                    var5.queueEvent("mag_swipe", var8);
                }
            }

            return true;
        }
        else
        {
            return false;
        }
    }

    public void onPlaced(EntityLiving var1, int var2)
    {
        if (var2 == 1)
        {
            this.facing = 1;
        }
        else
        {
            this.facing = (byte)(var2 ^ 1);
        }
    }
}
