package immibis.ccperiphs.rfid;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.mod_ImmibisPeripherals;
import immibis.core.net.TESync;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;

public class TileRFIDWriter extends TilePeriphs implements IPeripheral, IInventory
{
    public static final int TICKS_TO_WRITE = 600;
    public static final int MAX_DATA_LENGTH = 80;
    public static final int MAX_LABEL_LENGTH = 20;
    public byte facing;
    volatile ItemStack contents = null;
    volatile int progress = 0;
    private volatile IComputerAccess computerToNotify = null;
    private volatile String rfidData;
    private volatile String label1;
    static final int STATE_EMPTY = 0;
    static final int STATE_IDLE = 1;
    static final int STATE_RUN = 2;
    static final float LID_RATE = 0.04F;
    float lidClosedAmt;
    int state = 0;
    int visualProgress;
    int heldCardColour;
    private static String[] methodNames = new String[] {"encode", "isPresent", "getProgress", "isCoded"};

    private void setState(int var1)
    {
        if (this.state != var1)
        {
            this.state = var1;
            this.world.notify(this.x, this.y, this.z);
        }
    }

    private void setVisualProgress(int var1)
    {
        if (this.visualProgress != var1)
        {
            this.visualProgress = var1;
            this.world.notify(this.x, this.y, this.z);
        }
    }

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        int var1 = this.facing | this.state << 8 | this.visualProgress << 16 | this.heldCardColour << 24;
        return TESync.make132(this.x, this.y, this.z, var1, 0, 0);
    }

    public void onDataPacket(Packet132TileEntityData var1)
    {
        int var2 = TESync.getFirst(var1);
        this.facing = (byte)var2;
        this.state = (byte)(var2 >> 8);
        this.visualProgress = (byte)(var2 >> 16);
        this.heldCardColour = (byte)(var2 >> 24);
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);

        if (this.contents != null)
        {
            NBTTagCompound var2 = new NBTTagCompound();
            this.contents.save(var2);
            var1.setCompound("item", var2);
        }

        var1.setByte("facing", this.facing);
        var1.setFloat("lid", this.lidClosedAmt);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);

        if (var1.hasKey("item"))
        {
            this.contents = ItemStack.a(var1.getCompound("item"));
        }

        this.facing = var1.getByte("facing");
        this.lidClosedAmt = var1.getFloat("lid");
    }

    private boolean canRun()
    {
        return this.contents != null && this.contents.id == mod_ImmibisPeripherals.itemRFID.id ? this.contents.tag == null || !this.contents.tag.hasKey("data") : false;
    }

    public void onPlaced(EntityLiving var1, int var2)
    {
        if (var2 == 1)
        {
            this.facing = 1;
        }
        else
        {
            this.facing = (byte)(var2 ^ 1);
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public synchronized void q_()
    {
        if (this.state == 2)
        {
            this.lidClosedAmt = Math.min(this.lidClosedAmt + 0.04F, 1.0F);
        }
        else
        {
            this.lidClosedAmt = Math.max(this.lidClosedAmt - 0.04F, 0.0F);
        }

        if (!this.world.isStatic)
        {
            if (this.progress > 0 && this.canRun())
            {
                --this.progress;
                this.setState(2);

                if (this.progress == 0)
                {
                    if (this.contents.tag == null)
                    {
                        this.contents.tag = new NBTTagCompound();
                    }

                    NBTTagCompound var1 = this.contents.tag;
                    var1.setString("data", this.rfidData);
                    var1.setString("line1", this.label1);

                    if (this.computerToNotify != null)
                    {
                        this.computerToNotify.queueEvent("rfid_written");
                        this.computerToNotify = null;
                    }
                }
            }
            else
            {
                this.progress = 0;
                this.setState(this.canRun() ? 1 : 0);
            }

            if (this.progress == 0)
            {
                this.setVisualProgress(this.isHoldingCodedCard() ? 11 : 0);
            }
            else
            {
                this.setVisualProgress((int)(12.0F * this.getProgress()));
            }

            int var2 = this.getHeldCardColour();

            if (this.heldCardColour != var2)
            {
                this.heldCardColour = var2;
                this.world.notify(this.x, this.y, this.z);
            }
        }
    }

    private synchronized boolean isHoldingCard()
    {
        return this.contents != null && this.contents.id == mod_ImmibisPeripherals.itemRFID.id;
    }

    private synchronized boolean isHoldingCodedCard()
    {
        return this.isHoldingCard() && this.contents.tag != null && this.contents.tag.hasKey("data");
    }

    public synchronized int getHeldCardColour()
    {
        return !this.isHoldingCard() ? -1 : this.contents.getData();
    }

    public String getType()
    {
        return "rfid writer";
    }

    public String[] getMethodNames()
    {
        return methodNames;
    }

    public synchronized Object[] callMethod(IComputerAccess var1, int var2, Object[] var3) throws Exception
    {
        switch (var2)
        {
            case 0:
                if (this.progress > 0)
                {
                    return new Object[] {Boolean.valueOf(false), "Already encoding"};
                }
                else if (this.contents == null)
                {
                    return new Object[] {Boolean.valueOf(false), "No card inserted"};
                }
                else if (this.contents.id != mod_ImmibisPeripherals.itemRFID.id)
                {
                    return new Object[] {Boolean.valueOf(false), "Foreign object blocking slot"};
                }
                else if (this.contents.tag != null && this.contents.tag.hasKey("data"))
                {
                    return new Object[] {Boolean.valueOf(false), "Card already encoded"};
                }
                else if (var3.length != 2 && var3.length != 3)
                {
                    return new Object[] {Boolean.valueOf(false), "Expected 2 arguments"};
                }
                else
                {
                    for (int var4 = 0; var4 < var3.length; ++var4)
                    {
                        if (!(var3[var4] instanceof String))
                        {
                            return new Object[] {Boolean.valueOf(false), "Expected string as argument " + var4};
                        }
                    }

                    this.rfidData = (String)var3[0];
                    this.label1 = (String)var3[1];
                    boolean var5 = var3.length == 3 && mod_ImmibisPeripherals.adminPassword != null && mod_ImmibisPeripherals.adminPassword.equals(var3[2]);

                    if (this.rfidData.length() > 80)
                    {
                        return new Object[] {Boolean.valueOf(false), "Maximum data length is 80 chars"};
                    }
                    else if (this.label1.length() > 20)
                    {
                        return new Object[] {Boolean.valueOf(false), "Maximum label length is 20 chars/line"};
                    }
                    else
                    {
                        this.computerToNotify = var1;
                        this.progress = var5 ? 1 : 600;
                        return new Object[] {Boolean.valueOf(true)};
                    }
                }

            case 1:
                return new Object[] {Boolean.valueOf(this.contents != null)};
            case 2:
                if (this.progress == 0)
                {
                    return new Object[] {Double.valueOf(-1.0D)};
                }

                return new Object[] {Double.valueOf(1.0D - (double)this.progress / 600.0D)};

            case 3:
                if (this.contents != null && this.contents.id == mod_ImmibisPeripherals.itemRFID.id)
                {
                    return new Object[] {Boolean.valueOf(this.contents.tag != null && this.contents.tag.hasKey("data"))};
                }

                return new Object[] {Boolean.valueOf(false)};

            default:
                return new Object[0];
        }
    }

    public boolean canAttachToSide(int var1)
    {
        return true;
    }

    public void attach(IComputerAccess var1, String var2) {}

    public synchronized void detach(IComputerAccess var1)
    {
        if (var1 == this.computerToNotify)
        {
            this.progress = 0;
            this.computerToNotify = null;
        }
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return 1;
    }

    /**
     * Returns the stack in slot i
     */
    public synchronized ItemStack getItem(int var1)
    {
        return var1 == 0 ? this.contents : null;
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public synchronized ItemStack splitStack(int var1, int var2)
    {
        if (var1 != 0)
        {
            return null;
        }
        else
        {
            ItemStack var3;

            if (this.contents != null && this.contents.count > var2)
            {
                this.contents.count -= var2;
                var3 = this.contents.cloneItemStack();
                var3.count = var2;
                return var3;
            }
            else
            {
                var3 = this.contents;
                this.contents = null;
                return var3;
            }
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public synchronized void setItem(int var1, ItemStack var2)
    {
        if (var1 == 0)
        {
            this.contents = var2;
        }
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "RFID writer";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 64;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return var1.e((double)this.x + 0.5D, (double)this.y + 0.5D, (double)this.z + 0.5D) <= 64.0D;
    }

    public void f() {}

    public void g() {}

    public synchronized boolean onBlockActivated(EntityHuman var1)
    {
        ItemStack var2 = var1.U();

        if (var2 != null && var2.id == mod_ImmibisPeripherals.itemRFID.id && this.contents == null)
        {
            this.contents = var2;
            var1.V();
            return true;
        }
        else if (var2 == null && this.contents != null && this.lidClosedAmt == 0.0F)
        {
            var1.inventory.setItem(var1.inventory.itemInHandIndex, this.contents);
            this.contents = null;
            return true;
        }
        else
        {
            return false;
        }
    }

    public synchronized float getProgress()
    {
        return 1.0F - (float)this.progress / 600.0F;
    }

	@Override
	public ItemStack[] getContents() {
		return new ItemStack[] {contents};
	}

	@Override
	public void setMaxStackSize(int arg0) {
	}
}
