package immibis.ccperiphs.speaker;

import immibis.core.net.IPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.EntityHuman;

public class PacketSpeakerStart implements IPacket
{
    public int x;
    public int y;
    public int z;
    public int dimension;
    public short[] mem;
    public boolean youAreOwner;
    public byte attenuation;
    public boolean isOn;
    public int[] serverFreqs;

    public byte getID()
    {
        return (byte)2;
    }

    public void read(DataInputStream var1) throws IOException
    {
        this.x = var1.readInt();
        this.y = var1.readInt();
        this.z = var1.readInt();
        this.dimension = var1.readInt();
        this.youAreOwner = var1.readBoolean();
        this.attenuation = var1.readByte();
        this.isOn = var1.readBoolean();
        int var2 = var1.readInt();
        this.mem = new short[var2];
        int var3;

        for (var3 = 0; var3 < var2; ++var3)
        {
            this.mem[var3] = var1.readShort();
        }

        byte var4 = var1.readByte();
        this.serverFreqs = new int[var4];

        for (var3 = 0; var3 < var4; ++var3)
        {
            this.serverFreqs[var3] = var1.readShort();
        }
    }

    public void write(DataOutputStream var1) throws IOException
    {
        var1.writeInt(this.x);
        var1.writeInt(this.y);
        var1.writeInt(this.z);
        var1.writeInt(this.dimension);
        var1.writeBoolean(this.youAreOwner);
        var1.writeByte(this.attenuation);
        var1.writeBoolean(this.isOn);
        var1.writeInt(this.mem.length);
        int var2;

        for (var2 = 0; var2 < this.mem.length; ++var2)
        {
            var1.writeShort(this.mem[var2]);
        }

        var1.writeByte((byte)this.serverFreqs.length);

        for (var2 = 0; var2 < this.serverFreqs.length; ++var2)
        {
            var1.writeShort((short)this.serverFreqs[var2]);
        }
    }

    public void onReceived(EntityHuman var1) {}
}
