package immibis.ccperiphs.speaker;

import immibis.core.net.IPacket;
import immibis.core.net.OneTwoFiveNetworking;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.World;

public abstract class Stream
{
    private byte[] buffer;
    private int writePos = 0;
    private int readPos = 0;
    private World world;
    private double x;
    private double y;
    private double z;
    private double dist_sq;
    private String channel;
    private boolean overflow;
    private int bytesPerTick;
    private Set players = new HashSet();

    private synchronized byte read()
    {
        if (this.writePos == this.readPos)
        {
            throw new IllegalStateException("Queue is empty");
        }
        else
        {
            byte var1 = this.buffer[this.readPos];
            this.readPos = (this.readPos + 1) % this.buffer.length;
            return var1;
        }
    }

    public Stream(World var1, double var2, double var4, double var6, double var8, String var10, int var11, int var12)
    {
        this.world = var1;
        this.x = var2;
        this.y = var4;
        this.z = var6;
        this.dist_sq = var8 * var8;
        this.channel = var10;
        this.buffer = new byte[var11];
        this.bytesPerTick = var12;
    }

    public synchronized void add(byte var1)
    {
        int var2 = (this.writePos + 1) % this.buffer.length;

        if (var2 == this.readPos)
        {
            this.overflow = true;
        }
        else
        {
            this.buffer[this.writePos] = var1;
            this.writePos = var2;
        }
    }

    public synchronized boolean hasCapacity(int var1)
    {
        int var2 = (this.writePos - this.readPos + this.buffer.length) % this.buffer.length;
        return var2 + var1 < this.buffer.length;
    }

    public abstract IPacket getStopPacket(EntityHuman var1);

    public abstract IPacket getStartPacket(EntityHuman var1);

    public abstract IPacket getStreamPacket(byte[] var1);

    public abstract void onTick();

    public abstract void onOverflow();

    public void tick()
    {
        if (!this.world.isStatic)
        {
            Iterator var2 = this.world.players.iterator();

            while (var2.hasNext())
            {
                EntityHuman var1 = (EntityHuman)var2.next();
                double var3 = var1.locX - this.x;
                double var5 = var1.locY - this.y;
                double var7 = var1.locZ - this.z;

                if (var3 * var3 + var5 * var5 + var7 * var7 > this.dist_sq)
                {
                    if (this.players.remove(var1))
                    {
                        OneTwoFiveNetworking.send(this.channel, this.getStopPacket(var1), var1);
                    }
                }
                else if (this.players.add(var1))
                {
                    OneTwoFiveNetworking.send(this.channel, this.getStartPacket(var1), var1);
                }
            }

            this.onTick();
            byte[] var10;

            synchronized (this)
            {
                if (this.writePos == this.readPos)
                {
                    return;
                }

                if (this.overflow)
                {
                    this.onOverflow();
                    this.overflow = false;
                }

                int var12 = (this.writePos - this.readPos + this.buffer.length) % this.buffer.length;
                var12 = Math.min(this.bytesPerTick, var12);
                var10 = new byte[var12];
                int var4 = 0;
                int var15 = var12 - 1;

                while (true)
                {
                    if (var15 < 0)
                    {
                        break;
                    }

                    var10[var4++] = this.read();
                    --var15;
                }
            }

            IPacket var11 = this.getStreamPacket(var10);
            Iterator var14 = this.players.iterator();

            while (var14.hasNext())
            {
                EntityHuman var13 = (EntityHuman)var14.next();
                OneTwoFiveNetworking.send(this.channel, var11, var13);
            }
        }
    }

    public synchronized void stop()
    {
        Iterator var2 = this.players.iterator();

        while (var2.hasNext())
        {
            EntityHuman var1 = (EntityHuman)var2.next();
            OneTwoFiveNetworking.send(this.channel, this.getStopPacket(var1), var1);
        }
    }
}
