package immibis.ccperiphs.speaker;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.mod_ImmibisPeripherals;
import immibis.core.net.IPacket;
import immibis.core.net.TESync;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;
import net.minecraft.server.World;

public class TileSpeaker extends TilePeriphs implements IPeripheral
{
    public static final byte OP_WRITE = 1;
    public static final byte OP_ON = 2;
    public static final byte OP_OFF = 3;
    public static final byte OP_EXECUTE = 4;
    public static final byte OP_ATTENUATE = 5;
    public static final byte OP_DEBUG_ON = 6;
    public static final byte OP_DEBUG_OFF = 7;
    public static final byte OP_START = 8;
    public static final byte OP_STOP = 9;
    public byte facing;
    public Stream stream = null;
    public static final double MAX_DISTANCE = 50.0D;
    public static final int MAX_BUFFER = 1024;
    public static final int MAX_RATE = 1024;
    public static final int MEMORY_SIZE = 16384;
    public static final int NUM_CHANNELS = 8;
    public short[] serverMemory = new short[16384];
    public int[] serverFreqs = new int[8];
    public boolean on = false;
    public byte attenuation = 20;
    private String owner;

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        return TESync.make132(this.x, this.y, this.z, this.facing, 0, 0);
    }

    public void onDataPacket(Packet132TileEntityData var1)
    {
        this.facing = (byte)TESync.getFirst(var1);
    }

    /**
     * invalidates a tile entity
     */
    public synchronized void j()
    {
        this.stream.stop();
        super.j();
    }

    public static int getDimension(World var0)
    {
        return var0.worldProvider.dimension;
    }

    /**
     * validates a tile entity
     */
    public synchronized void m()
    {
        final int var1 = getDimension(this.world);
        this.stream = new Stream(this.world, (double)this.x + 0.5D, this.y + 0.5D, (double)this.z + 0.5D, MAX_DISTANCE, mod_ImmibisPeripherals.CHANNEL, MAX_BUFFER, MAX_RATE)
        {
            public void onTick() {}
            public void onOverflow() {}
            public IPacket getStreamPacket(byte[] var1x)
            {
                PacketSpeakerStream var2 = new PacketSpeakerStream();
                var2.data = var1x;
                var2.dimension = var1;
                var2.x = TileSpeaker.this.x;
                var2.y = TileSpeaker.this.y;
                var2.z = TileSpeaker.this.z;
                return var2;
            }
            public IPacket getStopPacket(EntityHuman var1x)
            {
                PacketSpeakerStop var2 = new PacketSpeakerStop();
                var2.x = TileSpeaker.this.x;
                var2.y = TileSpeaker.this.y;
                var2.z = TileSpeaker.this.z;
                var2.dimension = var1;
                return var2;
            }
            public IPacket getStartPacket(EntityHuman var1x)
            {
                PacketSpeakerStart var2 = new PacketSpeakerStart();
                var2.x = TileSpeaker.this.x;
                var2.y = TileSpeaker.this.y;
                var2.z = TileSpeaker.this.z;
                var2.dimension = var1;
                var2.mem = TileSpeaker.this.serverMemory;
                var2.youAreOwner = var1x.name.equals(TileSpeaker.this.owner);
                var2.attenuation = TileSpeaker.this.attenuation;
                var2.isOn = TileSpeaker.this.on;
                var2.serverFreqs = TileSpeaker.this.serverFreqs;
                return var2;
            }
        };
    }

    public String getType()
    {
        return "speaker";
    }

    public String[] getMethodNames()
    {
        return new String[] {"write", "reboot", "shutdown", "startup", "getMemorySize", "execute", "setAttenuation", "debugOn", "debugOff", "start", "stop"};
    }

    public Object[] callMethod(IComputerAccess var1, int var2, Object[] var3) throws Exception
    {
        if (this.stream == null)
        {
            return new Object[] {"No stream"};
        }
        else
        {
            int var4;
            int var6;

            switch (var2)
            {
                case 0:
                    if (var3.length < 2)
                    {
                        return new Object[] {"Not enough arguments"};
                    }

                    if (var3.length > 256)
                    {
                        return new Object[] {"Too many arguments"};
                    }

                    Object[] var9 = var3;
                    var6 = var3.length;
                    int var5;

                    for (var5 = 0; var5 < var6; ++var5)
                    {
                        Object var8 = var9[var5];

                        if (!(var8 instanceof Double))
                        {
                            return new Object[] {"All arguments must be numbers"};
                        }
                    }

                    for (var4 = 1; var4 < var3.length; ++var4)
                    {
                        var5 = (int)((Double)var3[var4]).doubleValue();

                        if (var5 < 0 || var5 > 65535)
                        {
                            return new Object[] {"Argument out of range (got " + var5 + ", must be between 0 and 65535)"};
                        }
                    }

                    var4 = (int)((Double)var3[0]).doubleValue();

                    if (var4 < 0 || var4 + var3.length - 1 >= 16384)
                    {
                        return new Object[] {"Address out of range (got " + var4 + ", must be between 0 and " + 16383 + ")"};
                    }

                    if (!this.stream.hasCapacity(var3.length * 2 + 3))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    this.stream.add((byte)1);
                    this.stream.add((byte)(var4 >> 8));
                    this.stream.add((byte)var4);
                    var5 = var3.length - 1;
                    this.stream.add((byte)(var5 >> 8));
                    this.stream.add((byte)var5);

                    for (var6 = 1; var6 < var3.length; ++var6)
                    {
                        short var10 = (short)((int)((Double)var3[var6]).doubleValue());
                        this.stream.add((byte)(var10 >> 8));
                        this.stream.add((byte)var10);
                        this.serverMemory[var4 + var6 - 1] = var10;
                    }

                    return null;

                case 1:
                    if (!this.stream.hasCapacity(2))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (this.on || this.isServerPlaying())
                    {
                        this.stream.add((byte)3);
                    }

                    this.stream.add((byte)2);
                    this.on = true;
                    break;

                case 2:
                    if (!this.stream.hasCapacity(1))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (this.on || this.isServerPlaying())
                    {
                        this.stream.add((byte)3);
                    }

                    this.on = false;
                    break;

                case 3:
                    if (!this.stream.hasCapacity(1))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (!this.on)
                    {
                        this.stream.add((byte)2);
                    }

                    this.on = true;
                    break;

                case 4:
                    return new Object[] {Integer.valueOf(16384)};
                case 5:
                    if (!this.stream.hasCapacity(3))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (var3.length != 1)
                    {
                        return new Object[] {"Wrong number of arguments"};
                    }

                    if (!(var3[0] instanceof Double))
                    {
                        return new Object[] {"Argument must be number"};
                    }

                    var4 = (int)((Double)var3[0]).doubleValue();

                    if (var4 < 0 || var4 >= 16384)
                    {
                        return new Object[] {"Argument out of range"};
                    }

                    this.stream.add((byte)4);
                    this.stream.add((byte)(var4 >> 8));
                    this.stream.add((byte)var4);
                    this.on = true;
                    break;

                case 6:
                    if (!this.stream.hasCapacity(2))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (var3.length != 1)
                    {
                        return new Object[] {"Wrong number of arguments"};
                    }

                    if (!(var3[0] instanceof Double))
                    {
                        return new Object[] {"Argument must be number"};
                    }

                    this.attenuation = (byte)((int)((Double)var3[0]).doubleValue());
                    this.stream.add((byte)5);
                    this.stream.add(this.attenuation);
                    break;

                case 7:
                    if (!this.stream.hasCapacity(1))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    this.stream.add((byte)6);
                    break;

                case 8:
                    if (!this.stream.hasCapacity(1))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    this.stream.add((byte)7);
                    break;

                case 9:
                    if (!this.stream.hasCapacity(4))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (!(var3[0] instanceof Double) || var3.length < 1)
                    {
                        return new Object[] {"Channel must be number"};
                    }

                    if (!(var3[1] instanceof Double) || var3.length < 2)
                    {
                        return new Object[] {"Frequency must be number"};
                    }

                    var6 = (int)((Double)var3[0]).doubleValue();
                    int var7 = (int)((Double)var3[1]).doubleValue();

                    if (var6 < 0 || var6 >= this.serverFreqs.length)
                    {
                        return new Object[] {"Invalid channel"};
                    }

                    this.serverFreqs[var6] = var7;
                    this.stream.add((byte)8);
                    this.stream.add((byte)var6);
                    this.stream.add((byte)(var7 >> 8));
                    this.stream.add((byte)var7);
                    break;

                case 10:
                    if (!this.stream.hasCapacity(2))
                    {
                        return new Object[] {"Buffer full"};
                    }

                    if (!(var3[0] instanceof Double) || var3.length < 1)
                    {
                        return new Object[] {"Channel must be number"};
                    }

                    var6 = (int)((Double)var3[0]).doubleValue();

                    if (var6 < 0 || var6 >= this.serverFreqs.length)
                    {
                        return new Object[] {"Invalid channel"};
                    }

                    this.serverFreqs[var6] = 0;
                    this.stream.add((byte)9);
                    this.stream.add((byte)var6);
            }

            return null;
        }
    }

    public boolean isServerPlaying()
    {
        int[] var4 = this.serverFreqs;
        int var3 = this.serverFreqs.length;

        for (int var2 = 0; var2 < var3; ++var2)
        {
            int var1 = var4[var2];

            if (var1 != 0)
            {
                return true;
            }
        }

        return false;
    }

    public boolean canAttachToSide(int var1)
    {
        return true;
    }

    public void attach(IComputerAccess var1, String var2) {}

    public void detach(IComputerAccess var1) {}

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        this.stream.tick();
    }

    public void onPlaced(EntityLiving var1, int var2)
    {
        if (var1 instanceof EntityHuman)
        {
            this.owner = ((EntityHuman)var1).name;
        }
        else
        {
            this.owner = null;
        }

        this.facing = (byte)(var2 ^ 1);
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);

        if (this.owner != null)
        {
            var1.setString("owner", this.owner);
        }

        var1.setByte("facing", this.facing);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);

        if (var1.hasKey("owner"))
        {
            this.owner = var1.getString("owner");
        }
        else
        {
            this.owner = null;
        }

        this.facing = var1.getByte("facing");
    }
}
