package immibis.ccperiphs.tape;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import immibis.ccperiphs.TilePeriphs;
import immibis.ccperiphs.mod_ImmibisPeripherals;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet132TileEntityData;

public class TileTapeDrive extends TilePeriphs implements IPeripheral, IInventory
{
    public static final int MAX_LABEL_LENGTH = 20;
    public static final int BYTES_PER_TICK = 5;
    public static final int BUFFER_SIZE = 100;
    private volatile Set computers = new HashSet();
    public byte facing;
    public volatile ItemStack contents;
    public static final int STATE_DIR_MASK = 3;
    public static final int STATE_STILL = 0;
    public static final int STATE_FORWARD = 1;
    public static final int STATE_BACKWARD = 2;
    public static final int STATE_FLAG_ON = 4;
    public int state;
    private static String[] methodNames = new String[] {"isPresent", "setLabel", "getCode", "setCode"};

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setByte("facing", this.facing);
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.facing = var1.getByte("facing");
    }

    private void updateState()
    {
        byte var1;

        if (this.computers.size() == 0)
        {
            var1 = 0;
        }
        else
        {
            var1 = 4;
        }

        if (this.state != var1)
        {
            this.state = var1;
            this.world.notify(this.x, this.y, this.z);
        }
    }

    /**
     * Overriden in a sign to provide the text
     */
    public Packet d()
    {
        Packet132TileEntityData var1 = new Packet132TileEntityData();
        var1.d = this.facing - 2 & 3 | this.state << 2;
        var1.lowPriority = true;
        var1.a = this.x;
        var1.b = this.y;
        var1.c = this.z;
        return var1;
    }

    public void onDataPacket(Packet132TileEntityData var1)
    {
        this.facing = (byte)((var1.d & 3) + 2);
        this.state = var1.d >> 2 & 63;
    }

    public String getType()
    {
        return "mag card reader";
    }

    public String[] getMethodNames()
    {
        return methodNames;
    }

    private boolean isTapeInserted()
    {
        return this.contents != null && this.contents.id == mod_ImmibisPeripherals.itemTape.id;
    }

    public synchronized Object[] callMethod(IComputerAccess var1, int var2, Object[] var3) throws Exception
    {
        switch (var2)
        {
            case 0:
                return new Object[] {Boolean.valueOf(this.isTapeInserted())};
            case 1:
                if (var3.length >= 1 && var3[0] instanceof String)
                {
                    if (!this.isTapeInserted())
                    {
                        return new Object[] {Boolean.valueOf(false), "no tape"};
                    }

                    String var5 = (String)var3[0];

                    if (var5.length() > 20)
                    {
                        return new Object[] {Boolean.valueOf(false), "label too long (max 20 chars)"};
                    }

                    if (this.contents.tag == null)
                    {
                        this.contents.tag = new NBTTagCompound();
                    }

                    this.contents.tag.setString("line1", var5);
                    this.world.b(this.x, this.y, this.z, this);
                    this.world.b(this.x, this.y, this.z, this);
                    return new Object[] {Boolean.valueOf(true)};
                }

                return new Object[] {Boolean.valueOf(false), "argument must be a string"};

            case 2:
                if (this.isTapeInserted() && this.contents.tag != null && this.contents.tag.hasKey("code"))
                {
                    return new Object[] {Integer.valueOf(this.contents.tag.getInt("code"))};
                }

            case 3:
                if (var3.length >= 1 && var3[0] instanceof Number)
                {
                    if (!this.isTapeInserted())
                    {
                        return new Object[] {Boolean.valueOf(false), "no tape"};
                    }

                    int var4 = ((Number)var3[0]).intValue();

                    if (this.contents.tag == null)
                    {
                        this.contents.tag = new NBTTagCompound();
                    }

                    this.contents.tag.setInt("code", var4);
                    this.world.b(this.x, this.y, this.z, this);
                    return new Object[] {Boolean.valueOf(true)};
                }

                return new Object[] {Boolean.valueOf(false), "argument must be a number"};

            default:
                return new Object[0];
        }
    }

    public boolean canAttachToSide(int var1)
    {
        return true;
    }

    public synchronized void attach(IComputerAccess var1, String var2)
    {
        this.computers.add(var1);
        this.updateState();
    }

    public synchronized void detach(IComputerAccess var1)
    {
        this.computers.remove(var1);
        this.computers.size();
        this.updateState();
    }

    public synchronized boolean onBlockActivated(EntityHuman var1)
    {
        ItemStack var2 = var1.U();

        if (var2 == null)
        {
            if (this.contents == null)
            {
                return false;
            }

            var1.inventory.setItem(var1.inventory.itemInHandIndex, this.contents);
            this.contents = null;
        }
        else
        {
            if (this.contents != null)
            {
                return false;
            }

            this.contents = var2;
            var1.inventory.setItem(var1.inventory.itemInHandIndex, (ItemStack)null);
        }

        this.world.b(this.x, this.y, this.z, this);
        return true;
    }

    public void onPlaced(EntityLiving var1, int var2)
    {
        if (var2 != 1 && var2 != 0)
        {
            this.facing = (byte)(var2 ^ 1);
        }
        else
        {
            this.facing = 2;
        }
    }

    /**
     * Returns the number of slots in the inventory.
     */
    public int getSize()
    {
        return 1;
    }

    /**
     * Returns the stack in slot i
     */
    public synchronized ItemStack getItem(int var1)
    {
        return var1 == 0 ? this.contents : null;
    }

    /**
     * Decrease the size of the stack in slot (first int arg) by the amount of the second int arg. Returns the new
     * stack.
     */
    public synchronized ItemStack splitStack(int var1, int var2)
    {
        if (var1 == 0 && this.contents != null)
        {
            ItemStack var3;

            if (var2 >= this.contents.count)
            {
                var3 = this.contents;
                this.contents = null;
            }
            else
            {
                var3 = this.contents.cloneItemStack();
                var3.count = var2;
                this.contents.count -= var2;
            }

            return var3;
        }
        else
        {
            return null;
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    /**
     * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
     */
    public synchronized void setItem(int var1, ItemStack var2)
    {
        if (var1 == 0)
        {
            this.contents = var2;
        }
    }

    /**
     * Returns the name of the inventory.
     */
    public String getName()
    {
        return "Tape drive";
    }

    /**
     * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
     * this more of a set than a get?*
     */
    public int getMaxStackSize()
    {
        return 64;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean a(EntityHuman var1)
    {
        return false;
    }

    public void f() {}

    public void g() {}

	@Override
	public ItemStack[] getContents() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setMaxStackSize(int arg0) {
		// TODO Auto-generated method stub
		
	}
}
