package immibis.ccperiphs.rfid;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class DyeCardRecipe implements IRecipe {
	
	public int cardID;
	
	public DyeCardRecipe(int cardID) {
		this.cardID = cardID;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting inv) {
		ItemStack card = null, dye = null;
		for(int k = 0; k < inv.getSizeInventory(); k++) {
			ItemStack s = inv.getStackInSlot(k);
			if(s == null)
				continue;
			
			if(s.itemID == cardID) {
				if(card != null)
					return null;
				card = s;
			} else if(s.itemID == Item.dyePowder.shiftedIndex) {
				if(dye != null)
					return null;
				dye = s;
			}
		}
		if(card == null || dye == null)
			return null;
		
		ItemStack result = card.copy();
		result.setItemDamage(15 - dye.getItemDamage());
		return result;
	}

	@Override
	public boolean matches(InventoryCrafting var1, World world) {
		return getCraftingResult(var1) != null;
	}

	@Override
	public int getRecipeSize() {
		return 2;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return new ItemStack(cardID, 1, 0);
	}

}
